<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefundCases extends Model
{
     use HasFactory;

    protected $table = 'refund_cases';

    protected $fillable = [
        'investment_master_id',
        'saving_id',
        'customer_id',
        'refund_amount',
        'zakat_amount',
        'profit_amount',
        'refund_request_date',
        'refund_processed_date',
        'processing_fee_deducted',
        'status',
        'type',
        'file',
        'status_updated_at'
    ];

    protected $casts = [
        'refund_amount' => 'decimal:2',
        'zakat_amount' => 'decimal:2',
        'profit_amount' => 'decimal:2',
        'processing_fee_deducted' => 'decimal:2',
        'refund_request_date' => 'date',
        'refund_processed_date' => 'date',
    ];

    public function investmentMaster()
    {
        return $this->belongsTo(InvestmentMaster::class);
    }

    //  public function saving()
    //  {
    //      return $this->belongsTo(CustomerSavingsMaster::class, 'saving_id');
    //  }

    public function customer()
    {
        return $this->belongsTo(CustomerInformation::class, 'customer_id');
    }
    
      public function customers()
    {
        return $this->belongsTo(EasypaisaUser::class, 'customer_id');
    }

}
