<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvestmentLedgerSaving extends Model
{
    use HasFactory;

    protected $table = 'investment_ledger_saving';

    protected $primaryKey = 'id';

    public $incrementing = true;

    //protected $keyType = 'bigint';

    public $timestamps = true;

    protected $fillable = [
        'customer_id',
        'saving_id',
        'transaction_id',
        'amount',
        'principal_amount',  // NEW - tracks deposit portion
        'profit_amount',     // NEW - tracks profit portion
        'zakat_amount',      // NEW - tracks zakat separately
        'transaction_type',
        'date_time',
        'net_amount',
        'gross_amount',
        'created_at',
        'updated_at'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'principal_amount' => 'decimal:2',  // NEW
        'profit_amount' => 'decimal:2',     // NEW
        'zakat_amount' => 'decimal:2',     // NEW
        'net_amount' => 'decimal:2',
        'gross_amount' => 'decimal:2',
        'date_time' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    /**
     * Relationship with Easypaisa Users
     */
    public function customer()
    {
        return $this->belongsTo(EasypaisaUser::class, 'customer_id');
    }

    /**
     * Relationship with Customer Savings Master
     */
    public function savings()
    {
        return $this->belongsTo(CustomerSavingsMaster::class, 'saving_id');
    }
}
