<?php

namespace App\Http\Controllers\Job;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DailyReturnJob extends Controller
{
        public function getDailyReturns(Request $request)
    {
        
        try {

            // Validate the request
            $validated = $request->validate([
                'msisdn' => 'required|string',
            ]);

            $msisdn=$validated['msisdn'];

            // Fetch user by MSISDN
            $user = EasypaisaUser::where('user_msisdn', $msisdn)->first();

            if (!$user) {
                return response()->json([
                    'status' => 404,
                    'message' => 'User not found.',
                    'exists' => false
                ], 404);
            }

            // Fetch latest 10 daily returns
            $dailyReturns = DailyReturn::where('customer_id', $user->id)
                ->orderBy('date', 'desc')
                ->limit(10)
                ->get();

            return response()->json([
                'status' => 200,
                'message' => 'Daily returns retrieved successfully.',
                'data' => $dailyReturns
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'execption' => $e,
                'message' => 'Something went wrong. Please try again.',
            ], 500);
        }
    }
}
