<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminAuthController;
use App\Http\Controllers\Admin\UserController;

use App\Http\Controllers\agent\AgentAuthController;
use App\Http\Controllers\agent\SubscriptionsController;
use App\Http\Controllers\agent\ReportController;
use App\Http\Controllers\reporter\ReporterAuthController;
use App\Http\Controllers\reporter\ExportController;
use App\Http\Controllers\reporter\ReportController as RepotsController;
use App\Http\Controllers\recusive_agents\AuthRecusiveAgentController;
use App\Http\Controllers\recusive_agents\AutoDebitController;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Admin
|--------------------------------------------------------------------------
|
*/


Route::prefix('admin')->group(function () {
    Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('superadmin.login');
    Route::post('/login', [AdminAuthController::class, 'login'])->name('superadmin.loginform');

    Route::middleware(['auth:admin','check.admin.session'])->group(function () {
        Route::get('/dashboard', [AdminAuthController::class, 'showDashboard'])->name('admin.dashboard');
        Route::post('/logout', [AdminAuthController::class, 'logout'])->name('superadmin.logout');

        Route::get('/index', [UserController::class, 'index'])->name('superadmin.index');
        Route::get('/create', [UserController::class, 'create'])->name('superadmin.create');
        Route::post('users/store', [UserController::class, 'store'])->name('superadmin.users.store');
        Route::get('users/edit/{planid}',[UserController::class,'edit'])->name('superadmin.users.edit');
        Route::post('users/update', [UserController::class, 'update'])->name('superadmin.users.update');

        Route::get('/show/Data', [UserController::class, 'showData'])->name('agentdata.index');

        Route::get('/team/lead', [UserController::class, 'teamleadindex'])->name('teamlead.index');
        Route::post('/team/lead', [UserController::class, 'teamleadstore'])->name('teamlead.store');

        Route::get('/Disposition/index', [UserController::class, 'dispositionindex'])->name('disposition.index');
        Route::post('/Disposition/store', [UserController::class, 'dispositionstore'])->name('disposition.store');



    });
});

/*
|--------------------------------------------------------------------------
| Agent
|--------------------------------------------------------------------------
|
*/
Route::prefix('agent')->group(function () {
    Route::get('/login', [AgentAuthController::class, 'showLoginForm'])->name('agent.login');

    Route::post('/login', [AgentAuthController::class, 'login'])->name('agent.loginform');

    Route::middleware(['web', 'agent', 'check.agent.session'])->group(function () {
        Route::get('/dashboard', [AgentAuthController::class, 'showDashboard'])->name('agents.dashboards');
        Route::post('/logout', [AgentAuthController::class, 'logout'])->name('agent.logout');

        Route::post('/agent/store', [AgentAuthController::class, 'store'])->name('agent.data.store');



    });
});


Route::get('/agent/session-expire', function () {
    // Manually destroy the session
    session()->flush();

});


/*
|--------------------------------------------------------------------------
|Other Routes
|--------------------------------------------------------------------------
|
*/

  Route::get('/', function (Request $request) {

      return view('welcome');
  });

// Cache Routes
Route::get('/clear-cache', function () {
    Artisan::call('config:cache');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    return redirect()->back()->with('success', 'All cache cleared');
})->name('clear.cache');
