@extends('superadmin.layouts.app')

@section('title')
    <title>Slabs</title>
@endsection

@section('content')


<div class="main-content">
    <div class="row">
        <div class="col-xl-12">
            <div class="card stretch stretch-full">
                <div class="card-body">
                    <form action="{{ route('superadmin.Slabs.store') }}" method="POST" class="needs-validation">
                        @csrf

                        <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label for="package_id" class="form-label">Package <span class="text-danger">*</span></label>
                                <select class="form-control" id="package_id" name="package_id" required>
                                    <option value="" disabled selected>Select a Package</option>
                                    @foreach($packages as $package)
                                        <option value="{{ $package->id }}">{{ $package->package_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label for="slab_name" class="form-label">Slab Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="slab_name" name="slab_name" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label for="initial_deposit" class="form-label">Initial Deposit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="initial_deposit" name="initial_deposit" step="0.01" required>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label for="maximum_deposit" class="form-label">Maximum Deposit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="maximum_deposit" name="maximum_deposit" step="0.01" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label for="daily_return_rate" class="form-label">Daily Return Rate (%) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="daily_return_rate" name="daily_return_rate" step="0.01" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12 text-end">
                                <button type="submit" class="btn btn-primary ">Save Slab</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection

@push('scripts')
<!-- Page Specific Scripts Finish -->
<script>
    document.getElementById('togglePassword').addEventListener('click', function (e) {
        // toggle the type attribute
        const passwordField = document.getElementById('password');
        const passwordFieldType = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', passwordFieldType);

        // toggle the eye icon
        const eyeIcon = document.getElementById('eyeIcon');
        if (passwordFieldType === 'password') {
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        } else {
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        }
    });
    </script>
<script src="{{asset('admin/assets/js/calendar.js')}}"></script>
 <!-- Page Specific Scripts Start -->
 <script src="{{asset('admin/assets/js/slick.min.js')}}"> </script>
 <script src="{{asset('admin/assets/js/moment.js')}}"> </script>
 <script src="{{asset('admin/assets/js/jquery.webticker.min.js')}}"> </script>
 <script src="{{asset('admin/assets/js/Chart.bundle.min.js')}}"> </script>
 <script src="{{asset('admin/assets/js/index-chart.js')}}"> </script>
@endpush
