<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\RefundCases;
use App\Models\Otp;
use Illuminate\Support\Facades\Http;

class ZakatController extends Controller
{
    public function index()
    {
        return view('zakat_form');
    }

public function upload(Request $request)
{
    $request->validate([
        'mobile' => 'required|regex:/^\d{10,15}$/',
        'zakat_pdf' => 'required|file|mimes:pdf|max:2048',
    ]);

    $mobile = preg_replace('/\D/', '', $request->mobile);

    // ✅ OTP Verification
    $otpVerified = Otp::where('mobile_number', $mobile)
                      ->where('is_verified', true)
                      ->orderBy('id', 'desc')
                      ->latest()
                      ->exists();

    if (!$otpVerified) {
        return response()->json(['success' => false, 'message' => 'OTP not verified']);
    }

    // ✅ Match user_msisdn with mobile number
    $refundCase = RefundCases::with('customers')
                    ->whereHas('customers', function ($q) use ($mobile) {
                        $q->where('user_msisdn', $mobile);
                    })
                    ->orderBy('id', 'desc')
                    ->latest()
                    ->first();

    if (!$refundCase) {
        return response()->json(['success' => false, 'message' => 'User not exist in this table']);
    }

    // ✅ Store the uploaded PDF
    $filename = 'zakat_' . $mobile . '_' . time() . '.pdf';
    $path = $request->file('zakat_pdf')->storeAs('public/uploads', $filename);

    // ✅ Save the file path into RefundCases table
    $refundCase->file = $filename;
    $refundCase->save();

    return response()->json(['success' => true, 'message' => 'Document uploaded successfully']);
}


public function sendOtp(Request $request)
{
    $request->validate([
        'mobile' => 'required|regex:/^\d{10,15}$/',
    ]);

    $otp = rand(100000, 999999); // Generate 6-digit OTP
    $mobile = preg_replace('/\D/', '', $request->mobile);
    $sms = "Your OTP for Zakat Form upload is: $otp";

    Http::withHeaders([
        'Authorization' => 'Bearer XXXXAAA489SMSTOKEFU',
        'Channelcode' => 'ITS',
    ])->post('http://api.efulife.com/itssr/its_sendsms', [
        'MobileNo' => $mobile,
        'sender' => '98902',
        'SMS' => $sms,
        'telco' => '',
    ]);

    Otp::create([
        'mobile_number' => $mobile,
        'otp' => $otp,
    ]);

    return response()->json(['status' => 'OTP sent']);
}

public function verifyOtp(Request $request)
{
    $request->validate([
        'mobile' => 'required',
        'otp' => 'required',
    ]);

    $otp = Otp::where('mobile_number', $request->mobile)
              ->where('otp', $request->otp)
              ->latest()
              ->orderBy('id', 'desc')
              ->first();

    if ($otp) {
        $otp->update(['is_verified' => true]);
        return response()->json(['status' => 'verified']);
    }

    return response()->json(['status' => 'invalid']);
}





}
