<?php $__env->startSection('title'); ?>
    <title>Active Packages</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="main-content">
    <div class="row">

        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-xxl-6 col-md-6">
            <!-- Make the entire box clickable by wrapping it in an anchor tag -->
            <a href="<?php echo e(route('superadmin.active.Packages.show', $package->id)); ?>" class="text-decoration-none">
                <div class="card stretch stretch-full">
                    <div class="card-body">
                        <p class="fs-11 fw-semibold text-uppercase text-muted"><?php echo e($package->type); ?></p>
                        <h4><span class="counter"><?php echo e($package->duration_breakage_days); ?> Days</span></h4>
                        <div class="hstack gap-2 mt-3">
                            <span class="fs-11 text-success badge bg-gray-100">
                                <i class="feather-trending-up fs-12 me-1"></i>
                                <span>Rs <?php echo e($package->processing_fee); ?></span>
                            </span>
                            <span class="fs-11 text-muted">Processing Fees</span>
                        </div>
                        <div class="mt-3">
                            <p class="text-muted">Package: <?php echo e($package->package_name); ?></p>
                            <p class="text-muted">Created At: <?php echo e(\Carbon\Carbon::parse($package->created_at)->format('Y-m-d H:i:s')); ?></p>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('superadmin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vtfmcyjg/bangladesh.al-fajrgroup.ae/easypaisa/resources/views/superadmin/activepackages/index.blade.php ENDPATH**/ ?>