<?php $__env->startSection('title'); ?>
    <title>Dashboard</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="main-content">
    <div class="row">

        <div class="col-xxl-6 col-md-6">
            <div class="card stretch stretch-full">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between mb-4">
                        <div class="d-flex gap-4 align-items-center">
                            <div class="avatar-text avatar-lg bg-gray-200">
                                <i class="feather-package"></i> <!-- Package Icon -->
                            </div>
                            <div>
                                <div class="fs-4 fw-bold text-dark">
                                    <span id="packagesCount">0</span> <!-- Total Packages Count -->
                                </div>
                                <h3 class="fs-13 fw-semibold text-truncate-1-line">Total Packages</h3>
                            </div>
                        </div>
                        <a href="javascript:void(0);" class="">
                            <i class="feather-more-vertical"></i>
                        </a>
                    </div>
                    <div class="pt-4">
                        <div class="d-flex align-items-center justify-content-between">
                            <a href="javascript:void(0);" class="fs-12 fw-medium text-muted text-truncate-1-line">Packages Overview</a>
                            <div class="w-100 text-end">
                                <span class="fs-12 text-dark">100%</span>
                                <span class="fs-11 text-muted">(Active)</span>
                            </div>
                        </div>
                        <div class="progress mt-2 ht-3">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 100%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-md-6">
            <div class="card stretch stretch-full">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between mb-4">
                        <div class="d-flex gap-4 align-items-center">
                            <div class="avatar-text avatar-lg bg-gray-200">
                                <i class="feather-layers"></i> <!-- Slabs Icon -->
                            </div>
                            <div>
                                <div class="fs-4 fw-bold text-dark">
                                    <span id="slabsCount">0</span> <!-- Total Slabs Count -->
                                </div>
                                <h3 class="fs-13 fw-semibold text-truncate-1-line">Total Slabs</h3>
                            </div>
                        </div>
                        <a href="javascript:void(0);" class="">
                            <i class="feather-more-vertical"></i>
                        </a>
                    </div>
                    <div class="pt-4">
                        <div class="d-flex align-items-center justify-content-between">
                            <a href="javascript:void(0);" class="fs-12 fw-medium text-muted text-truncate-1-line">Slabs Overview</a>
                            <div class="w-100 text-end">
                                <span class="fs-12 text-dark">N/A</span>
                            </div>
                        </div>
                        <div class="progress mt-2 ht-3">
                            <div class="progress-bar bg-success" role="progressbar" style="width: 80%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- KIBOR Rates -->
            <div class="col-xxl-3 col-md-6">
                <div class="card stretch stretch-full">
                    <div class="card-body">
                        <div class="d-flex align-items-start justify-content-between mb-4">
                            <div class="d-flex gap-4 align-items-center">
                                <div class="avatar-text avatar-lg bg-gray-200">
                                    <i class="feather-bar-chart-2"></i> <!-- KIBOR Icon -->
                                </div>
                                <div>
                                    <div class="fs-4 fw-bold text-dark">
                                        <span id="kiborRatesCount">0</span>
                                    </div>
                                    <h3 class="fs-13 fw-semibold text-truncate-1-line">KIBOR Rates</h3>
                                </div>
                            </div>
                            <a href="javascript:void(0);" class="">
                                <i class="feather-more-vertical"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Refund Cases -->
            <div class="col-xxl-3 col-md-6">
                <div class="card stretch stretch-full">
                    <div class="card-body">
                        <div class="d-flex align-items-start justify-content-between mb-4">
                            <div class="d-flex gap-4 align-items-center">
                                <div class="avatar-text avatar-lg bg-gray-200">
                                    <i class="feather-refresh-ccw"></i> <!-- Refund Icon -->
                                </div>
                                <div>
                                    <div class="fs-4 fw-bold text-dark">
                                        <span id="refundCasesCount">0</span>
                                    </div>
                                    <h3 class="fs-13 fw-semibold text-truncate-1-line">Refund Cases</h3>
                                </div>
                            </div>
                            <a href="javascript:void(0);" class="">
                                <i class="feather-more-vertical"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Holidays -->
            <div class="col-xxl-3 col-md-6">
                <div class="card stretch stretch-full">
                    <div class="card-body">
                        <div class="d-flex align-items-start justify-content-between mb-4">
                            <div class="d-flex gap-4 align-items-center">
                                <div class="avatar-text avatar-lg bg-gray-200">
                                    <i class="feather-calendar"></i> <!-- Holiday Icon -->
                                </div>
                                <div>
                                    <div class="fs-4 fw-bold text-dark">
                                        <span id="holidaysCount">0</span>
                                    </div>
                                    <h3 class="fs-13 fw-semibold text-truncate-1-line">Holidays</h3>
                                </div>
                            </div>
                            <a href="javascript:void(0);" class="">
                                <i class="feather-more-vertical"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Insurance Benefits -->
            <div class="col-xxl-3 col-md-6">
                <div class="card stretch stretch-full">
                    <div class="card-body">
                        <div class="d-flex align-items-start justify-content-between mb-4">
                            <div class="d-flex gap-4 align-items-center">
                                <div class="avatar-text avatar-lg bg-gray-200">
                                    <i class="feather-shield"></i> <!-- Insurance Icon -->
                                </div>
                                <div>
                                    <div class="fs-4 fw-bold text-dark">
                                        <span id="insuranceBenefitsCount">0</span>
                                    </div>
                                    <h3 class="fs-13 fw-semibold text-truncate-1-line">Insurance Benefits</h3>
                                </div>
                            </div>
                            <a href="javascript:void(0);" class="">
                                <i class="feather-more-vertical"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="row">
            <!-- Accounts Users -->
            <div class="col-lg-4">
                <div class="card mb-4 stretch stretch-full">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div class="d-flex gap-3 align-items-center">
                            <div class="avatar-text">
                                <i class="feather feather-user"></i>
                            </div>
                            <div>
                                <div class="fw-semibold text-dark">Accounts Users</div>
                                <div class="fs-12 text-muted">Accounts Section</div>
                            </div>
                        </div>
                        <div class="fs-4 fw-bold text-dark" id="accountsUsersCount">0</div>
                    </div>
                </div>
            </div>

            <!-- Investment Users -->
            <div class="col-lg-4">
                <div class="card mb-4 stretch stretch-full">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div class="d-flex gap-3 align-items-center">
                            <div class="avatar-text">
                                <i class="feather feather-briefcase"></i>
                            </div>
                            <div>
                                <div class="fw-semibold text-dark">Investment Users</div>
                                <div class="fs-12 text-muted">Investment Section</div>
                            </div>
                        </div>
                        <div class="fs-4 fw-bold text-dark" id="investmentUsersCount">0</div>
                    </div>
                </div>
            </div>

            <!-- Operations Users -->
            <div class="col-lg-4">
                <div class="card mb-4 stretch stretch-full">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div class="d-flex gap-3 align-items-center">
                            <div class="avatar-text">
                                <i class="feather feather-settings"></i>
                            </div>
                            <div>
                                <div class="fw-semibold text-dark">Operations Users</div>
                                <div class="fs-12 text-muted">Operations Section</div>
                            </div>
                        </div>
                        <div class="fs-4 fw-bold text-dark" id="operationsUsersCount">0</div>
                    </div>
                </div>
            </div>
        </div>


        

    </div>
</div>





<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        fetchCounts();

        function fetchCounts() {
            $.ajax({
                url: "<?php echo e(route('dashboard.counts')); ?>",
                method: "GET",
                success: function (response) {
                    // Update the counts on the dashboard
                    $('#packagesCount').text(response.packages_count);
                    $('#slabsCount').text(response.slabs_count);
                    $('#kiborRatesCount').text(response.kibor_rates_count);
                    $('#refundCasesCount').text(response.refund_cases_count);
                    $('#holidaysCount').text(response.holidays_count);
                    $('#insuranceBenefitsCount').text(response.insurance_benefits_count);
                },
                error: function (xhr) {
                    console.error("Error fetching counts:", xhr);
                }
            });
        }
    });
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('superadmin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\easypaisa\resources\views/superadmin/deshboard.blade.php ENDPATH**/ ?>