<nav class="nxl-navigation">
    <div class="navbar-wrapper">
        <div class="m-header">
            <a href="<?php echo e(route('operations.dashboards')); ?>" class="b-brand">
                <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Logo" class="logo logo-lg" />
                <img src="<?php echo e(asset('assets/images/sm-ep.jpg')); ?>" alt="Small Logo" class="logo logo-sm" />
            </a>
        </div>
        <div class="navbar-content">
            <ul class="nxl-navbar">
                <li class="nxl-item nxl-caption">
                    <label>Navigation</label>
                </li>

                
                <?php
                    $dashboardActive = Request::is('super-admin/dashboards');
                ?>
                <li class="nxl-item nxl-hasmenu <?php echo e($dashboardActive ? 'active' : ''); ?>">
                    <a href="javascript:void(0);" class="nxl-link">
                        <span class="nxl-micon"><i class="feather-airplay"></i></span>
                        <span class="nxl-mtext">Dashboards</span>
                        <span class="nxl-arrow"><i class="feather-chevron-right"></i></span>
                    </a>
                    <ul class="nxl-submenu <?php echo e($dashboardActive ? 'show' : ''); ?>">
                        <li class="nxl-item <?php echo e($dashboardActive ? 'active' : ''); ?>">
                            <a class="nxl-link" href="<?php echo e(route('operations.dashboards')); ?>">Analytics Dashboard</a>
                        </li>
                    </ul>
                </li>

                
                <?php
                    $refundActive = Request::is('super-admin/operation/RefundReport');
                    $illustrationActive = Request::is('super-admin/operation/illustrationReport');
                    $operationsActive = $refundActive || $illustrationActive;
                ?>
                <li class="nxl-item nxl-hasmenu <?php echo e($operationsActive ? 'active' : ''); ?>">
                    <a href="javascript:void(0);" class="nxl-link">
                        <span class="nxl-micon"><i class="feather-file-text"></i></span>
                        <span class="nxl-mtext">Operations Reports</span>
                        <span class="nxl-arrow"><i class="feather-chevron-right"></i></span>
                    </a>
                    <ul class="nxl-submenu <?php echo e($operationsActive ? 'show' : ''); ?>">
                        <li class="nxl-item <?php echo e($refundActive ? 'active' : ''); ?>">
                            <a class="nxl-link" href="<?php echo e(route('operation.RefundReport')); ?>">Zakat Withdrawal Requests</a>
                        </li>
                        <li class="nxl-item <?php echo e($illustrationActive ? 'active' : ''); ?>">
                            <a class="nxl-link" href="<?php echo e(route('operation.illustrationReport')); ?>">Customer Illustrations Report</a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
<?php /**PATH /home/vtfmcyjg/bangladesh.al-fajrgroup.ae/easypaisa/resources/views/operations/layouts/side-bar.blade.php ENDPATH**/ ?>