

<?php $__env->startSection('title'); ?>
    <title>Active Packages</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!-- [ Main Content ] start -->
    <div class="main-content">
        <div class="tab-content">
            <div class="tab-pane fade active show" id="proposalTab">
                <div class="row">


                    <div class="col-lg-12">
                        <div class="card stretch stretch-full">
                            <div class="card-body">
                                <h4 class="fw-bold mb-4">Package Details</h4>
                                <div class="row">
                                    <!-- Left side (4 fields) -->
                                    <div class="col-md-6">
                                        <div class="fs-13 text-muted lh-lg">
                                            <div>
                                                <span class="fw-semibold text-dark border-bottom border-bottom-dashed">Package Name:</span>
                                                <span><?php echo e($package->package_name); ?></span>
                                            </div>
                                            <div>
                                                <span class="fw-semibold text-dark border-bottom border-bottom-dashed">Type:</span>
                                                <span><?php echo e($package->type); ?></span>
                                            </div>
                                            <div>
                                                <span class="fw-semibold text-dark border-bottom border-bottom-dashed">Minimum Duration (Days):</span>
                                                <span><?php echo e($package->min_duration_days); ?></span>
                                            </div>
                                            <div>
                                                <span class="fw-semibold text-dark border-bottom border-bottom-dashed">Maximum Duration (Days):</span>
                                                <span><?php echo e($package->max_duration_days); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Right side (3 fields) -->
                                    <div class="col-md-6">
                                        <div class="fs-13 text-muted lh-lg">
                                            <div>
                                                <span class="fw-semibold text-dark border-bottom border-bottom-dashed">Breakage Duration (Days):</span>
                                                <span><?php echo e($package->duration_breakage_days); ?></span>
                                            </div>
                                            <div>
                                                <span class="fw-semibold text-dark border-bottom border-bottom-dashed">Processing Fee:</span>
                                                <span>Rs <?php echo e($package->processing_fee); ?></span>
                                            </div>
                                            <div>
                                                <span class="fw-semibold text-dark border-bottom border-bottom-dashed">Created At:</span>
                                                <span><?php echo e(\Carbon\Carbon::parse($package->created_at)->format('Y-m-d H:i:s')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="card stretch stretch-full">
                            <div class="card-header">
                                <h5 class="card-title">Slabs</h5>
                                <a href="<?php echo e(route('superadmin.Slabs.create')); ?>" class="btn btn-md btn-light-brand">
                                    <i class="feather-plus me-2"></i>
                                    <span>New Slabs</span>
                                </a>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    

                                    <div class="card-body p-0">
                                        <div class="table-responsive">
                                            <table id="kiborRatesTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>Slabs</th>
                                                        <th>Policy Rate</th>
                                                        <th>Customer%</th>
                                                        <th>EP%</th>
                                                        <th>EFUL%</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $Slabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $policyRate = 11; // Default policy rate
                                                            $customerPercent = 0;
                                                            $epPercent = 0;
                                                            $efulPercent = 1;

                                                            if ($slab->initial_deposit >= 2000 && $slab->maximum_deposit <= 9999) {
                                                                $customerPercent = 4;
                                                                $epPercent = 6;
                                                            } elseif ($slab->initial_deposit >= 10000 && $slab->maximum_deposit <= 49999) {
                                                                $customerPercent = 5;
                                                                $epPercent = 5;
                                                            } elseif ($slab->initial_deposit >= 50000 && $slab->maximum_deposit <= 149999) {
                                                                $customerPercent = 6;
                                                                $epPercent = 4;
                                                            } elseif ($slab->initial_deposit >= 150000 && $slab->maximum_deposit <= 200000) {
                                                                $customerPercent = 7;
                                                                $epPercent = 3;
                                                            }
                                                        ?>

                                                        <tr>
                                                            <td><?php echo e(number_format($slab->initial_deposit, 2)); ?> - <?php echo e(number_format($slab->maximum_deposit, 2)); ?></td>
                                                            <td><?php echo e($policyRate); ?>%</td>
                                                            <td><?php echo e($customerPercent); ?>%</td>
                                                            <td><?php echo e($epPercent); ?>%</td>
                                                            <td><?php echo e($efulPercent); ?>%</td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="col-lg-12">
                        <div class="card stretch stretch-full">
                            <div class="card-header">
                                <h5 class="card-title">Insurance Benefits</h5>
                                <a href="<?php echo e(route('superadmin.insurancebenefits.create')); ?>" class="btn btn-md btn-light-brand">
                                    <i class="feather-plus me-2"></i>
                                    <span>New InsuranceBenefit</span>
                                </a>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="row">
                                        <div class="row">
                                            <?php $__currentLoopData = $InsuranceBenefit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $benefit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div class="card stretch stretch-full">
                                                        <div class="card-body">
                                                            <div class="avatar-text rounded-2 mb-4">
                                                                <i class="feather-shield"></i>  <!-- You can change the icon to match the benefit type -->
                                                            </div>
                                                            <h6 class="fw-bold mb-3 text-truncate-1-line"><?php echo e($benefit->benefit_name); ?></h6>
                                                            <p class="text-muted mb-4 text-truncate-3-line">
                                                                Benefit Type: <?php echo e($benefit->benefit_type); ?><br>
                                                                Description: <?php echo e($benefit->benefit_description); ?><br>
                                                                Amount: Rs <?php echo e($benefit->amount); ?>

                                                            </p>
                                                            <p class="text-muted mb-4">Created At: <?php echo e(\Carbon\Carbon::parse($benefit->created_at)->format('Y-m-d H:i:s')); ?></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="card stretch stretch-full">
                            <div class="card-header">
                                <h5 class="card-title">Companies</h5>

                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="row">
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-xxl-4 col-md-6">
                                                <div class="card stretch stretch-full">
                                                    <div class="card-body">
                                                        <div class="avatar-text rounded-2 mb-4">
                                                            <i class="feather-briefcase"></i> <!-- You can change the icon if needed -->
                                                        </div>
                                                        <h6 class="fw-bold mb-3"><?php echo e($company->name); ?></h6>
                                                        <p class="text-muted mb-4">
                                                            <strong>Address:</strong> <?php echo e($company->address); ?><br>
                                                            <strong>Contact Number:</strong> <?php echo e($company->contact_number); ?><br>
                                                            <strong>Registration Number:</strong> <?php echo e($company->registration_number); ?><br>
                                                            <strong>Business Type:</strong> <?php echo e($company->business_type); ?><br>
                                                            <strong>Registration Date:</strong> <?php echo e(\Carbon\Carbon::parse($company->registration_date)->format('Y-m-d')); ?>

                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>




<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('superadmin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vtfmcyjg/bangladesh.al-fajrgroup.ae/easypaisa/resources/views/superadmin/activepackages/show.blade.php ENDPATH**/ ?>