<?php $__env->startSection('title'); ?>
    <title>Slabs</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="main-content">
    <div class="row">
        <div class="col-xl-12">
            <div class="card stretch stretch-full">
                <div class="card-body">
                    <form action="<?php echo e(route('superadmin.Slabs.store')); ?>" method="POST" class="needs-validation">
                        <?php echo csrf_field(); ?>

                        <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label for="package_id" class="form-label">Package <span class="text-danger">*</span></label>
                                <select class="form-control" id="package_id" name="package_id" required>
                                    <option value="" disabled selected>Select a Package</option>
                                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($package->id); ?>"><?php echo e($package->package_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label for="slab_name" class="form-label">Slab Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="slab_name" name="slab_name" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label for="initial_deposit" class="form-label">Initial Deposit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="initial_deposit" name="initial_deposit" step="0.01" required>
                            </div>
                            <div class="col-lg-6 mb-4">
                                <label for="maximum_deposit" class="form-label">Maximum Deposit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="maximum_deposit" name="maximum_deposit" step="0.01" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6 mb-4">
                                <label for="daily_return_rate" class="form-label">Daily Return Rate (%) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="daily_return_rate" name="daily_return_rate" step="0.01" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12 text-end">
                                <button type="submit" class="btn btn-primary ">Save Slab</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Page Specific Scripts Finish -->
<script>
    document.getElementById('togglePassword').addEventListener('click', function (e) {
        // toggle the type attribute
        const passwordField = document.getElementById('password');
        const passwordFieldType = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', passwordFieldType);

        // toggle the eye icon
        const eyeIcon = document.getElementById('eyeIcon');
        if (passwordFieldType === 'password') {
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        } else {
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        }
    });
    </script>
<script src="<?php echo e(asset('admin/assets/js/calendar.js')); ?>"></script>
 <!-- Page Specific Scripts Start -->
 <script src="<?php echo e(asset('admin/assets/js/slick.min.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/moment.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/jquery.webticker.min.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/Chart.bundle.min.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/index-chart.js')); ?>"> </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('superadmin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vtfmcyjg/bangladesh.al-fajrgroup.ae/easypaisa/resources/views/superadmin/Slabs/create.blade.php ENDPATH**/ ?>