<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EFU Life Assurance - EasyPaisa Takaful Savings Plan</title>
    <style>

         @font-face {
        font-family: 'NotoNastaliqUrdu';
        font-style: normal;
        font-weight: normal;
        src: url('<?php echo e(storage_path('fonts/NotoNastaliqUrdu-Bold.ttf')); ?>') format('truetype');
    }
    
    .urdu {
        font-family: 'NotoNastaliqUrdu', sans-serif;
        direction: rtl;
        text-align: right;
        unicode-bidi: embed;
    }

        body {
            font-family: Arial, sans-serif;
            font-size: 10pt;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
        }
        .company-name {
            font-weight: bold;
            font-size: 12pt;
        }
        .document-title {
            font-weight: bold;
            margin: 10px 0;
        }
        .client-info {
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        th, td {
            border: 1px solid #000;
            padding: 5px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f2f2f2;
        }
        .bilingual {
            display: block;
        }
        .english {
            margin-bottom: 5px;
        }
        /* .urdu {
            direction: rtl;
            font-family: 'NotoNastaliqUrdu-Bold', sans-serif;
            text-align: right;
        } */
        .notes {
            margin-top: 20px;
        }
        .signature-section {
            margin-top: 50px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name bilingual">
            <span class="english">EFU Life Assurance Ltd</span>
            <span class="urdu">/ ای ایف یو لائف اشورنس لمیٹڈ</span>
        </div>
        <div class="bilingual">
            <span class="english">Window Takaful Operations /</span>
            <span class="urdu">ونڈو تکافل آپريشنز</span>
        </div>
        <div class="document-title bilingual">
            <span class="english"> <u>Illustration of Benefits for EasyPaisa Takaful Savings Plan / </u></span>
            <span class="urdu"><u>فوائد کی تصریح براۓ ایزی پیسہ تکافل سیونگس پلان</u></span>
        </div>
    </div>

    <div class="client-info">
        <div class="bilingual">
            <span class="english">Prepared for <?php echo e($clientName ?? 'Mr Sample'); ?></span>
        </div>
    </div>

    <div class="section-title bilingual">
        <span class="english"><b>Basic Details</span>
        <span class="urdu">بنیادی تفصیلات</b></span>
    </div>

    <table>
        <tr>
            <td width="30%">
                <div class="bilingual">
                    <span class="english">Reference Number</span>
                    <span class="urdu">حوالہ نمبر</span>
                </div>
            </td>
            <td width="20%"><?php echo e($referenceNumber ?? '092-BMF'); ?></td>
            <td width="30%">
                <div class="bilingual">
                    <span class="english">Date of birth</span>
                    <span class="urdu">تاریخ پیدائش</span>
                </div>
            </td>
            <td width="20%"><?php echo e($dob ?? 'Not Applicable'); ?></td>
        </tr>
        <tr>
            <td>
                <div class="bilingual">
                    <span class="english">Name of Participant</span>
                    <span class="urdu">نام براۓ شریکِ تکافل</span>
                </div>
            </td>
            <td><?php echo e($participantName ?? 'Mr Sample'); ?></td>
            <td>
                <div class="bilingual">
                    <span class="english">Age</span>
                    <span class="urdu">عمر</span>
                </div>
            </td>
            <td><?php echo e($age ?? 'Not Applicable'); ?></td>
        </tr>
        <tr>
            <td>
                <div class="bilingual">
                    <span class="english">Expected Commencement Date</span>
                    <span class="urdu">متوقع تاریخ آغاز</span>
                </div>
            </td>
            <td><?php echo e($commencementDate ?? '4/1/2025'); ?></td>
            <td>
                <div class="bilingual">
                    <span class="english">Valid Till</span>
                    <span class="urdu">تاریخ تک معتبر</span>
                </div>
            </td>
            <td><?php echo e($validTill ?? '4/1/2028'); ?></td>
        </tr>
    </table>

    <div class="section-title bilingual">
        <span class="english"><b>Coverage Details </span>
        <span class="urdu">تحفظ کی تفصیلات</b></span>
    </div>

    <table>
        <tr>
            <td width="35%">
                <div class="bilingual">
                    <span class="english">Currency of Plan - Rupees <br></span>
                    <span class="urdu">پلان کی کرنسی - روپے</span>
                </div>
            </td>
            
            <td width="35%">
                <div class="bilingual">
                    <span class="english"><b>Mode of Payment</b></span>
                    <span class="english">: <?php echo e($paymentMode ?? 'Single'); ?> <br></span>
                   
                    <span class="urdu">ادائیگی کا طریقہ کار</span>
                    <span class="urdu">: <?php echo e($paymentModeUrdu ?? 'سنگل'); ?></span>
                </div>
            </td>
        
            <td>
                <div class="bilingual">
                    <span class="english"><b>Type:</b></span>
                    <span class="english"><?php echo e($planType ?? 'Level'); ?> <br></span>
                    <span class="urdu">نوعیت</span>
                    <span class="urdu"><?php echo e($planTypeUrdu ?? 'سادہ'); ?></span>
                </div>
            </td>
            
        </tr>
    </table>

    <table>
        <thead>
            <tr>
                <th width="30%">
                    <div class="bilingual">
                        <span class="english">Name of Plan</span>
                        <span class="urdu">پلان کا نام</span>
                    </div>
                </th>
                <th width="15%">
                    <div class="bilingual">
                        <span class="english">Sum Covered</span>
                        <span class="urdu">سم کورڈ</span>
                    </div>
                </th>
                <th width="15%">
                    <div class="bilingual">
                        <span class="english">Coverage Term</span>
                        <span class="urdu">مدت تحفظ</span>
                    </div>
                </th>
                <th width="20%">
                    <div class="bilingual">
                        <span class="english">Contribution Paying Term</span>
                        <span class="urdu">زرِ تکافل کے ادائیگی کی مدت</span>
                    </div>
                </th>
                <th width="20%">
                    <div class="bilingual">
                        <span class="english">Single Contribution</span>
                        <span class="urdu">سنگل زرِ تکافل</span>
                    </div>
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>EasyPaisa Takaful Savings Plan [ Protection Multiple = 1.25 ]</td>
                <td><?php echo e($sumCovered ?? '25,000'); ?></td>
                <td><?php echo e($coverageTerm ?? '3 Years'); ?></td>
                <td><?php echo e($contributionTerm ?? 'Single Premium'); ?></td>
                <td><?php echo e($singleContribution ?? '20,000'); ?></td>
            </tr>
            <tr>
                <td>Accidental Death Benefit (Built in)</td>
                <td><?php echo e($accidentalDeathBenefit ?? '25,000'); ?></td>
                <td><?php echo e($coverageTerm ?? '3 Years'); ?></td>
                <td>-</td>
                <td>-</td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: right;">
                    <div class="bilingual">
                        <span class="english"><b>Total Single Contribution</span>
                        <span class="urdu">کل سنگل کا زرِتکافل</b></span>
                    </div>
                </td>
                <td><?php echo e($totalSingleContribution ?? '20,000'); ?></td>
            </tr>
        </tbody>
    </table>

    <div class="section-title bilingual">
        <span class="english">Illustrative Values</span>
        <span class="urdu">تصريحی ماليت <br></span>
    </div>
    <span class="english"><br></span>
    <div class="bilingual">
        <span class="english">The table below provides expected benefits under the EasyPaisa Takaful Savings Plan for its duration</span>
        <span class="urdu">نیچے دی گئی جدول پیسہ تکافل سیونگس پلان کے تحت اس کی مدت کے لیے متوقع فوائد فراہم کرتی ہے۔<br></span>
    </div>

    <div class="bilingual">
        <span class="english"><br>Expected Cash / surrender values are net of all charges including takaful donation, policy administration fee, fund management charges etc., as described in the brochure, policy document and website of the EFU Life Assurance<br></span>
        <span class="urdu"> متوقع نقد ماليت تمام اخراجات بشمول تکافل ڈونيشن، انتظامی اخراجات، فنڈ مینجمنٹ چارجز وغیرہ، جو بروشر، پالیسی دستاویز اورای ایف یو لائف اشورنس لمیٹڈ کی ویب سائٹ میں بیان کیے گئے ہیں</span>
    </div>
    <div>
        <span class="english"><br></span>
    </div>
    <table>
        <thead>
            <tr>
                <th rowspan="2" width="10%">
                    <div class="bilingual">
                        <span class="english">Policy Year</span>
                        <span class="urdu">پالیسی کا سال</span>
                    </div>
                </th>
                <th rowspan="2" width="15%">
                    <div class="bilingual">
                        <span class="english">Cumulative Main Plan Contributions Paid</span>
                        <span class="urdu">بنيادی پلان کا ادا شدہ زرِ تکافل</span>
                    </div>
                </th>
                <th rowspan="2" width="15%">
                    <div class="bilingual">
                        <span class="english">Allocated to fund (net of allocation charges)</span>
                        <span class="urdu">فنڈ کے لیے مختص (مختص کے اخراجات کی کٹوتی کے بعد)</span>
                    </div>
                </th>
                <th colspan="2" width="30%">
                    <div class="bilingual">
                        <span class="english">9% p.a. Expected Rate of Return</span>
                        <span class="urdu">9%سالانہ متوقع شرح منافع</span>
                    </div>
                </th>
                <th colspan="2" width="30%">
                    <div class="bilingual">
                        <span class="english">13% p.a. Expected Rate of Return</span>
                        <span class="urdu">13%سالانہ متوقع شرح منافع</span>
                    </div>
                </th>
            </tr>
            <tr>
                <th>
                    <div class="bilingual">
                        <span class="english">Regular Contribution Surrender Value plus FAC Surrender Value</span>
                        <span class="urdu">بنيادی پلان اور اضافی اختیاری زرِ تکافل کی مجموعی دسبرداری کی مالیت</span>
                    </div>
                </th>
                <th>
                    <div class="bilingual">
                        <span class="english">Main Plan Death Benefit</span>
                        <span class="urdu">بنيادی پلان کے فوائد وفات کی صورت میں</span>
                    </div>
                </th>
                <th>
                    <div class="bilingual">
                        <span class="english">Regular Contribution Surrender Value plus FAC Surrender Value</span>
                        <span class="urdu">بنيادی پلان اور اضافی اختیاری زرِ تکافل کی مجموعی دسبرداری کی مالیت</span>
                    </div>
                </th>
                <th>
                    <div class="bilingual">
                        <span class="english">Main Plan Death Benefit</span>
                        <span class="urdu">بنيادی پلان کے فوائد وفات کی صورت میں</span>
                    </div>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $illustrativeValues ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($value['year'] ?? ''); ?></td>
                <td><?php echo e($value['contributions'] ?? ''); ?></td>
                <td><?php echo e($value['allocated'] ?? ''); ?></td>
                <td><?php echo e($value['9p_surrender'] ?? ''); ?></td>
                <td><?php echo e($value['9p_death'] ?? ''); ?></td>
                <td><?php echo e($value['13p_surrender'] ?? ''); ?></td>
                <td><?php echo e($value['13p_death'] ?? ''); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <?php if(empty($illustrativeValues)): ?>
            <tr>
                <td>1</td>
                <td>20,000</td>
                <td>20,000</td>
                <td>20,800</td>
                <td>25,000</td>
                <td>20,801</td>
                <td>25,000</td>
            </tr>
            <tr>
                <td>2</td>
                <td>20,000</td>
                <td>20,000</td>
                <td>21,632</td>
                <td>25,000</td>
                <td>21,633</td>
                <td>25,000</td>
            </tr>
            <tr>
                <td>3</td>
                <td>20,000</td>
                <td>20,000</td>
                <td>22,497</td>
                <td>25,000</td>
                <td>22,498</td>
                <td>25,000</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="section-title bilingual">
        <span class="english">Notes</span>
        <span class="urdu">نوٹ</span>
    </div>

    <div class="bilingual">
        <span class="english">Allocation charges at the following rates, have been deducted from the contribution per year before the amount is allocated to the relevant fund:</span>
        <span class="urdu">مندرجہ ذیل شرحوں پر مختص چارجز، متعلقہ فنڈ میں رقم مختص کرنے سے پہلے ہر سال زرِ تکافل سے کاٹ لیے گئے ہیں</span>
    </div>

    <table style="width: 50%;">
        <thead>
            <tr>
                <th width="50%">
                    <div class="bilingual">
                        <span class="english">Year</span>
                    </div>
                </th>
                <th width="50%">
                    <div class="bilingual">
                        <span class="english">Allocation Charges (%)</span>
                    </div>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $allocationCharges ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($charge['year'] ?? ''); ?></td>
                <td><?php echo e($charge['rate'] ?? ''); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <?php if(empty($allocationCharges)): ?>
            <tr>
                <td>Year 1 and Onwards</td>
                <td>Nill</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="bilingual">
        <span class="english">The illustrative values do not take into account any partial surrenders.</span>
        <span class="urdu">اوپر دی گئی تصريحی ماليت کسی بھی قسم کی جزوی دستبرداری کو ظاہر نہيں کرتی.</span>
    </div>

    <div class="bilingual">
        <span class="english">Death Benefit is greater of Sum Covered or Cash Value.</span>
    </div>
</body>
</html><?php /**PATH C:\xampp\htdocs\easypaisa\resources\views/pdfs/benefit.blade.php ENDPATH**/ ?>