

<?php $__env->startSection('title'); ?>
    <title>Refund Customer  || Index</title>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('styles'); ?>
    <!-- Datatable -->
    <link href="https://cdn.datatables.net/v/dt/dt-1.13.6/datatables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/fixedheader/3.3.2/css/fixedHeader.bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.4.1/css/responsive.bootstrap.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-lg-12">
                <div class="card stretch stretch-full">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4>Refund Customer </h4>
                  
                        <div class="dataTables_filter d-flex gap-2 align-items-center">
                                  <select id="statusFilter" class="form-control">
                               <option value="Under-Process">Under-Process</option>
                                     <option value="Accepted">Accepted</option>
                                     <option value="Rejected">Rejected</option>
                               </select>
                            <input type="date" id="from_date" class="form-control" placeholder="From Date">
                            <input type="date" id="to_date" class="form-control" placeholder="To Date">
                            <input type="text" id="customSearch" class="form-control" placeholder="Search by name">
                            <button id="exportCsv" class="btn btn-success btn-lg">
                                <i class="fas fa-download"></i> Export
                            </button>
                        </div>

                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="invTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        
                                       
                                       <th>User MSISDN</th>
                                       <th>First Name</th>
                                       <th>Last Name</th>
                                       <th>Email Address</th>
                                       <th>Refund Amount</th>
                                         <th>Zakat Amount</th>
                                           <th>Profit Amount</th>
                                             <th>Refund request date</th>
                                               <th>Refund processed date</th>
                                                 <th>Processing fee deducted</th>
                                       <th>Date</th>
                                       <th>Status</th>
                                        <th>Actions</th>



                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- DataTable will populate this dynamically -->
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <!-- Page Specific Scripts Finish -->



   <script>
$(document).ready(function() {
    var table = $('#invTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?php echo e(route('operation.RefundReport')); ?>',
            data: function(d) {
                d.from_date = $('#from_date').val();
                d.to_date = $('#to_date').val();
                d.search_name = $('#customSearch').val();
                d.status = $('#statusFilter').val();
            }
        },
        lengthChange: false,
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'user_msisdn', name: 'customers.user_msisdn' },
            { data: 'first_name', name: 'customers.first_name' },
            { data: 'last_name', name: 'customers.last_name' },
            { data: 'email_address', name: 'customers.email_address' },
            { data: 'refund_amount', name: 'refund_amount' },
              { data: 'zakat_amount', name: 'zakat_amount' },
                { data: 'profit_amount', name: 'profit_amount' },
                  { data: 'refund_request_date', name: 'refund_request_date' },
                    { data: 'refund_processed_date', name: 'refund_processed_date' },
                      { data: 'processing_fee_deducted', name: 'processing_fee_deducted' },
            { data: 'created_at', name: 'created_at' },
           {
    data: 'status',
    name: 'status'
},
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });

    // Filters
    $('#from_date, #to_date, #customSearch, #statusFilter').on('change keyup', function() {
        table.draw();
    });

    // CSV export
    $('#exportCsv').on('click', function() {
        let from = $('#from_date').val();
        let to = $('#to_date').val();
        let search = $('#customSearch').val();
        window.location.href = '<?php echo e(route('operation.exportRefundReport')); ?>?from_date=' + from +
            '&to_date=' + to + '&search_name=' + search;
    });

    // Accept/Reject actions
    $('#invTable').on('click', '.accept-btn, .reject-btn', function() {
        const refundId = $(this).data('id');
        const newStatus = $(this).hasClass('accept-btn') ? 'Accepted' : 'Rejected';

        $.ajax({
            url: '<?php echo e(route('operation.updateRefundStatus')); ?>',
            type: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                refund_id: refundId,
                status: newStatus
            },
            success: function() {
                $('#invTable').DataTable().ajax.reload(null, false);
            },
            error: function() {
                alert('Failed to update status');
            }
        });
    });
});
</script>



    <!-- Global Required Scripts Start -->
    <script src="<?php echo e(asset('admin/assets/js/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/js/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/js/jquery-ui.min.js')); ?>"></script>
    <!-- Page Specific Scripts Finish -->
    <script src="https://cdn.datatables.net/v/dt/dt-1.13.6/datatables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <!-- <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap.min.js"></script> -->
    <script src="https://cdn.datatables.net/fixedheader/3.3.2/js/dataTables.fixedHeader.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.4.1/js/responsive.bootstrap.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <!-- medjestic core JavaScript -->
    <script src="<?php echo e(asset('admin/assets/js/framework.js')); ?>"></script>
    <!-- Settings -->
    <script src="<?php echo e(asset('admin/assets/js/settings.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('operations.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vtfmcyjg/bangladesh.al-fajrgroup.ae/easypaisa/resources/views/operations/RefundCustomer/index.blade.php ENDPATH**/ ?>