<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zakat Exemption Form Upload</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        :root {
            --primary-color: #01808d;
            --primaryfprintf-dark: #016b76;
            --light-gray: #f5f7fa;
            --medium-gray: #e1e5eb;
            --dark-gray: #6c757d;
            --white: #ffffff;
            --success: #28a745;
            --error: #dc3545;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--light-gray);
            color: #333;
            line-height: 1.6;
        }

        .header-container {
            background: var(--white);
            padding: 1rem 1rem;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .logo {
            height: 80px;
        }

        .page-title {
            color: var(--primary-color);
            font-weight: 600;
            font-size: 1.8rem;
            margin: 0;
        }

        .container {
            display: flex;
            max-width: 1100px;
            margin: 2rem auto;
            background: var(--white);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            border-radius: 10px;
            overflow: hidden;
        }

        .left, .right {
            padding: 2.5rem;
        }

        .left {
            flex: 1;
            background: var(--light-gray);
            border-right: 1px solid var(--medium-gray);
        }

        .right {
            flex: 1;
        }

        footer {
            text-align: center;
            background: var(--primary-color);
            color: var(--white);
            padding: 1.2rem;
            margin-top: 2rem;
            font-size: 0.9rem;
        }

        h2 {
            color: var(--primary-color);
            margin-bottom: 1.5rem;
            font-weight: 600;
            font-size: 1.5rem;
        }

        label {
            display: block;
            margin: 1.2rem 0 0.5rem;
            font-weight: 500;
            color: var(--primary-dark);
        }

        input[type="text"],
        input[type="file"] {
            width: 100%;
            padding: 0.8rem 1.2rem;
            margin: 0.3rem 0;
            border: 1px solid var(--medium-gray);
            border-radius: 6px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        input[type="text"]:focus,
        input[type="file"]:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(1, 128, 141, 0.2);
        }

        input[type="file"] {
            padding: 0.5rem;
            background: var(--white);
        }

        button {
            background: var(--primary-color);
            color: var(--white);
            border: none;
            padding: 0.8rem 1.8rem;
            margin-top: 1.5rem;
            border-radius: 6px;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            width: 100%;
        }

        button:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .success {
            color: var(--success);
            background: #e8f5e9;
            padding: 0.8rem;
            border-radius: 6px;
            margin: 1rem 0;
            border-left: 4px solid var(--success);
        }

        .error {
            color: var(--error);
            background: #fde8e8;
            padding: 0.8rem;
            border-radius: 6px;
            margin: 1rem 0;
            border-left: 4px solid var(--error);
        }

        .download-link {
            display: inline-block;
            margin-top: 1.5rem;
            padding: 0.8rem 1.5rem;
            background: var(--primary-color);
            color: var(--white);
            text-decoration: none;
            border-radius: 6px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .download-link:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        ul {
            padding-left: 1.2rem;
            margin: 1rem 0;
        }

        li {
            margin-bottom: 0.8rem;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }

        .modal-content {
            background: var(--white);
            padding: 2rem;
            border-radius: 10px;
            max-width: 500px;
            width: 90%;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            animation: slideIn 0.3s ease-out;
        }

        .modal-content h3 {
            color: var(--primary-color);
            margin-bottom: 1rem;
            font-size: 1.5rem;
        }

        .modal-content p {
            color: var(--dark-gray);
            margin-bottom: 1.5rem;
        }

        .modal-content button {
            width: auto;
            padding: 0.8rem 2rem;
        }

        @keyframes slideIn {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        @media (max-width: 768px) {
            .container {
                flex-direction: column;
                margin: 1rem;
            }

            .left {
                border-right: none;
                border-bottom: 1px solid var(--medium-gray);
            }

            .page-title {
                font-size: 1.5rem;
            }

            .left, .right {
                padding: 1.5rem;
            }

            .logo {
                height: 60px;
            }

            .modal-content {
                width: 95%;
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>

<div class="header-container">
    <img src="{{asset('logo.svg')}}" alt="Company Logo" class="logo">
</div>
<h2 style="text-align: center; color: #01808d; margin-top: 2rem; font-size: 2rem;">Zakat Declaration Form</h2>

<div class="container">
    <div class="left">
        <h2>Instructions</h2>
        <ul>
            <li>Download the Zakat Exemption Form below.</li>
            <li>Fill in the required details clearly.</li>
            <li>Scan the signed form into a PDF format.</li>
            <li>Upload the completed PDF using the form on the right.</li>
        </ul>
        <a href="zakat_form_sample.pdf" class="download-link" download>Download Zakat Exemption Form</a>
    </div>

    <div class="right">
        <h2>Upload Completed Form</h2>
          @if(session('success'))
        <div class="success">{{ session('success') }}</div>
    @endif

    @if($errors->any())
        <div class="error">
            <ul>
                @foreach($errors->all() as $err)
                    <li>❌ {{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

   <!-- Zakat Upload Form -->
<form id="zakatForm" action="{{ route('zakat.upload') }}" method="POST" enctype="multipart/form-data">
    @csrf
    <label for="mobile">Mobile Number:</label>
    <input type="text" name="mobile" id="mobile" placeholder="03xxxxxxxxx" required>

    <label for="zakat_pdf">Upload Zakat PDF:</label>
    <input type="file" name="zakat_pdf" id="zakat_pdf" accept="application/pdf" required>

    <button type="button" onclick="handleUpload()">Upload</button>
</form>



    </div>
</div>

<!-- Modal -->
<div class="modal" id="successModal">
    <div class="modal-content">
        <h3>Submission Successful</h3>
        <p>Your Zakat Exemption Form has been submitted successfully. Your withdrawal will be processed in a couple of hours.</p>
        <button onclick="closeModal()">OK</button>
    </div>
</div>

<!-- OTP Modal -->
<!-- OTP Modal -->
<div id="otpModal" style="display:none; position:fixed; top:30%; left:35%; background:#fff; padding:20px; border:1px solid #ccc; z-index:1000;">
    <h4>Enter OTP</h4>
    <input type="text" id="otp_input" placeholder="Enter OTP">
    <div id="otpError" style="color:red; margin-top:5px;"></div>
    <button onclick="verifyOtp()">Verify</button>
    <button onclick="closeModal()">Cancel</button>
</div>


<footer>
    For support, call 111-123-456 | All rights reserved © <?= date('Y') ?>
</footer>

<script>
function handleUpload() {
    const mobile = document.getElementById('mobile').value;

    if (!mobile) {
        alert('Please enter mobile number first.');
        return;
    }

    // Send OTP via AJAX
    fetch('{{ route("zakat.sendOtp") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ mobile: mobile })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'OTP sent') {
            document.getElementById('otpModal').style.display = 'block';
        } else {
            alert('Failed to send OTP.');
        }
    });
}

function closeModal() {
    document.getElementById('otpModal').style.display = 'none';
    document.getElementById('otpError').innerText = '';
    document.getElementById('otp_input').value = '';
}

function verifyOtp() {
    const mobile = document.getElementById('mobile').value;
    const otp = document.getElementById('otp_input').value;
    const form = document.getElementById('zakatForm');
    const formData = new FormData(form);

    if (!otp) {
        document.getElementById('otpError').innerText = 'Please enter OTP';
        return;
    }

    // Verify OTP
    fetch('{{ route("zakat.verifyOtp") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ mobile: mobile, otp: otp })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'verified') {
            // OTP verified: Submit form via AJAX
            fetch(form.action, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: formData
            })
            .then(res => res.json())
            .then(uploadRes => {
                if (uploadRes.success) {
        Swal.fire({
            icon: 'success',
            title: 'Success',
            text: '✅ Document uploaded successfully!',
        });
        closeModal();
        form.reset();
    } else {
        Swal.fire({
            icon: 'warning',
            title: 'MSISDN Not Found',
            text: '⚠️ MSISDN does not exist in the refund causes.',
        });
          closeModal();
        form.reset();
    }
            });
        } else {
            document.getElementById('otpError').innerText = '❌ Wrong OTP!';
        }
    });
}
</script>


@if(session('success'))
<div class="modal" id="successModal" style="display:block;">
    <div class="modal-content">
        <h3>Submission Successful</h3>
        <p>{{ session('success') }}</p>
        <button onclick="closeModal()">OK</button>
    </div>
</div>
@endif


</body>
</html>
