<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EFU Life Assurance - EFU Life Takaful Savings Plan</title>
    <style>

         @font-face {
        font-family: 'NotoNastaliqUrdu';
        font-style: normal;
        font-weight: normal;
        src: url('{{ storage_path('fonts/NotoNastaliqUrdu-Bold.ttf') }}') format('truetype');
    }
    
    .urdu {
        font-family: 'NotoNastaliqUrdu', sans-serif;
        direction: rtl;
        text-align: right;
        unicode-bidi: embed;
    }

        body {
            font-family: Arial, sans-serif;
            font-size: 10pt;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
        }
        .company-name {
            font-weight: bold;
            font-size: 12pt;
        }
        .document-title {
            font-weight: bold;
            margin: 10px 0;
        }
        .client-info {
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        th, td {
            border: 1px solid #000;
            padding: 5px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f2f2f2;
        }
        .bilingual {
            display: block;
        }
        .english {
            margin-bottom: 5px;
        }
        /* .urdu {
            direction: rtl;
            font-family: 'NotoNastaliqUrdu-Bold', sans-serif;
            text-align: right;
        } */
        .notes {
            margin-top: 20px;
        }
        .signature-section {
            margin-top: 50px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name bilingual">
            <span class="english">EFU Life Assurance Ltd /</span>
            <span class="urdu"> ای ایف یو لائف اشورنس لمیٹڈ</span>
        </div>
        <div class="bilingual">
            <span class="english">Window Takaful Operations /</span>
            <span class="urdu">ونڈو تکافل آپريشنز</span>
        </div>
        <div class="document-title bilingual">
            <span class="english"> <u>Illustration of Benefits for EFU Life Takaful Savings Plan / </u></span>
            <span class="urdu"><u>فوائد کی تصریح براۓ ای ایف یو لائف تکافل سیونگس پلان</u></span>

        </div>
    </div>

    <div class="client-info">
        <div class="bilingual">
            <span class="english">Prepared for {{ $clientName ?? 'Mr Sample' }}</span>
        </div>
    </div>

    <div class="section-title bilingual">
        <span class="english"><b>Basic Details</span>
        <span class="urdu">بنیادی تفصیلات</b></span>
    </div>

    <table>
        <tr>
            <td width="30%">
                <div class="bilingual">
                    <span class="english">Reference Number</span>
                    <span class="urdu">حوالہ نمبر</span>
                </div>
            </td>
            <td width="20%">{{ $referenceNumber ?? '092-BMF' }}</td>
            <td width="30%">
                <div class="bilingual">
                    <span class="english">Date of birth</span>
                    <span class="urdu">تاریخ پیدائش</span>
                </div>
            </td>
            <td width="20%">{{ $dob ?? 'Not Applicable' }}</td>
        </tr>
        <tr>
            <td>
                <div class="bilingual">
                    <span class="english">Name of Participant</span>
                    <span class="urdu">نام براۓ شریکِ تکافل</span>
                </div>
            </td>
            <td>{{ $participantName ?? 'Mr Sample' }}</td>
            <td>
                <div class="bilingual">
                    <span class="english">Age</span>
                    <span class="urdu">عمر</span>
                </div>
            </td>
            <td>{{ $age ?? 'Not Applicable' }}</td>
        </tr>
        <tr>
            <td>
                <div class="bilingual">
                    <span class="english">Expected Commencement Date</span>
                    <span class="urdu">متوقع تاریخ آغاز</span>
                </div>
            </td>
            <td>{{ $commencementDate ?? '4/1/2025' }}</td>
            <td>
                <div class="bilingual">
                    <span class="english">Valid Till</span>
                    <span class="urdu">تاریخ تک معتبر</span>
                </div>
            </td>
            <td>{{ $validTill ?? '4/1/2028' }}</td>
        </tr>
    </table>

    <div class="section-title bilingual">
        <span class="english"><b>Coverage Details </span>
        <span class="urdu">تحفظ کی تفصیلات</b></span>
    </div>

    <table>
        <tr>
            <td width="35%">
                <div class="bilingual">
                    <span class="english">Currency of Plan - Rupees <br></span>
                    <span class="urdu">پلان کی کرنسی - روپے</span>
                </div>
            </td>
            
            <td width="35%">
                <div class="bilingual">
                    <span class="english"><b>Mode of Payment</b></span>
                    <span class="english">: {{ $paymentMode ?? 'Single' }} <br></span>
                   
                    <span class="urdu">ادائیگی کا طریقہ کار</span>
                    <span class="urdu">: {{ $paymentModeUrdu ?? 'سنگل' }}</span>
                </div>
            </td>
        
            <td>
                <div class="bilingual">
                    <span class="english"><b>Type:</b></span>
                    <span class="english">{{ $planType ?? 'Level' }} <br></span>
                    <span class="urdu">نوعیت</span>
                    <span class="urdu">{{ $planTypeUrdu ?? 'سادہ' }}</span>
                </div>
            </td>
            
        </tr>
    </table>

    <table>
        <thead>
            <tr>
                <th width="30%">
                    <div class="bilingual">
                        <span class="english">Name of Plan</span>
                        <span class="urdu">پلان کا نام</span>
                    </div>
                </th>
                <th width="15%">
                    <div class="bilingual">
                        <span class="english">Sum Covered</span>
                        <span class="urdu">سم کورڈ</span>
                    </div>
                </th>
                <th width="15%">
                    <div class="bilingual">
                        <span class="english">Coverage Term</span>
                        <span class="urdu">مدت تحفظ</span>
                    </div>
                </th>
                <th width="20%">
                    <div class="bilingual">
                        <span class="english">Contribution Paying Term</span>
                        <span class="urdu">زرِ تکافل کے ادائیگی کی مدت</span>
                    </div>
                </th>
                <th width="20%">
                    <div class="bilingual">
                        <span class="english">Single Contribution</span>
                        <span class="urdu">سنگل زرِ تکافل</span>
                    </div>
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>EFU Life Takaful Savings Plan [ Coverage Multiple = 1.25 ]</td>
                <td>{{ $sumCovered ?? '25,000' }}</td>
                <td>{{ $coverageTerm ?? '3 Years' }}</td>
                <td>{{ $contributionTerm ?? 'Single Contribution' }}</td>
                <td>{{ $singleContribution ?? '20,000' }}</td>
            </tr>
            <tr>
                <td>Accidental Death Benefit (Built in)</td>
                <td>{{ $accidentalDeathBenefit ?? '25,000' }}</td>
                <td>{{ $coverageTerm ?? '3 Years' }}</td>
                <td>-</td>
                <td>-</td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: right;">
                    <div class="bilingual">
                        <span class="english"><b>Total Single Contribution</span>
                        <span class="urdu">کل سنگل کا زرِتکافل</b></span>
                    </div>
                </td>
                <td>{{ $totalSingleContribution ?? '20,000' }}</td>
            </tr>
        </tbody>
    </table>

    <div class="section-title bilingual">
        <span class="english">Illustrative Values</span>
        <span class="urdu">تصريحی ماليت <br></span>
    </div>
    <span class="english"><br></span>
    <div class="bilingual">
        <span class="english">The table below provides expected benefits under the EFU Life Takaful Savings Plan for its duration</span>
        <span class="urdu">نیچے دی گئی جدول پیسہ تکافل سیونگس پلان کے تحت اس کی مدت کے لیے متوقع فوائد فراہم کرتی ہے۔<br></span>
    </div>

    <div class="bilingual">
        <span class="english"><br>Expected Cash / surrender values are net of all charges including takaful donation, policy administration fee, fund management charges etc., as described in the brochure, policy document and website of the EFU Life Assurance<br></span>
        <span class="urdu"> متوقع نقد ماليت تمام اخراجات بشمول تکافل ڈونيشن، انتظامی اخراجات، فنڈ مینجمنٹ چارجز وغیرہ، جو بروشر، پالیسی دستاویز اورای ایف یو لائف اشورنس لمیٹڈ کی ویب سائٹ میں بیان کیے گئے ہیں</span>
    </div>
    <div>
        <span class="english"><br></span>
    </div>
    <table>
        <thead>
            <tr>
                <th rowspan="2" width="10%">
                    <div class="bilingual">
                        <span class="english">Policy Year</span>
                        <span class="urdu">پالیسی کا سال</span>
                    </div>
                </th>
                <th rowspan="2" width="15%">
                    <div class="bilingual">
                        <span class="english">Cumulative Main Plan Contributions Paid</span>
                        <span class="urdu">بنيادی پلان کا ادا شدہ زرِ تکافل</span>
                    </div>
                </th>
                <th rowspan="2" width="15%">
                    <div class="bilingual">
                        <span class="english">Allocated to fund (net of allocation charges)</span>
                        <span class="urdu">فنڈ کے لیے مختص (مختص کے اخراجات کی کٹوتی کے بعد)</span>
                    </div>
                </th>
                <th colspan="2" width="30%">
                    <div class="bilingual">
                        <span class="english">9% p.a. Expected Rate of Return</span>
                        <span class="urdu">9%سالانہ متوقع شرح منافع</span>
                    </div>
                </th>
                <th colspan="2" width="30%">
                    <div class="bilingual">
                        <span class="english">13% p.a. Expected Rate of Return</span>
                        <span class="urdu">13%سالانہ متوقع شرح منافع</span>
                    </div>
                </th>
            </tr>
            <tr>
                <th>
                    <div class="bilingual">
                        <span class="english">Regular Contribution Surrender Value plus FAC Surrender Value</span>
                        <span class="urdu">بنيادی پلان اور اضافی اختیاری زرِ تکافل کی مجموعی دسبرداری کی مالیت</span>
                    </div>
                </th>
                <th>
                    <div class="bilingual">
                        <span class="english">Main Plan Death Benefit</span>
                        <span class="urdu">بنيادی پلان کے فوائد وفات کی صورت میں</span>
                    </div>
                </th>
                <th>
                    <div class="bilingual">
                        <span class="english">Regular Contribution Surrender Value plus FAC Surrender Value</span>
                        <span class="urdu">بنيادی پلان اور اضافی اختیاری زرِ تکافل کی مجموعی دسبرداری کی مالیت</span>
                    </div>
                </th>
                <th>
                    <div class="bilingual">
                        <span class="english">Main Plan Death Benefit</span>
                        <span class="urdu">بنيادی پلان کے فوائد وفات کی صورت میں</span>
                    </div>
                </th>
            </tr>
        </thead>
        <tbody>
            @foreach($illustrativeValues ?? [] as $value)
            <tr>
                <td>{{ $value['year'] ?? '' }}</td>
                <td>{{ $value['contributions'] ?? '' }}</td>
                <td>{{ $value['allocated'] ?? '' }}</td>
                <td>{{ $value['9p_surrender'] ?? '' }}</td>
                <td>{{ $value['9p_death'] ?? '' }}</td>
                <td>{{ $value['13p_surrender'] ?? '' }}</td>
                <td>{{ $value['13p_death'] ?? '' }}</td>
            </tr>
            @endforeach
            
            @empty($illustrativeValues)
            <tr>
                <td>1</td>
                <td>20,000</td>
                <td>20,000</td>
                <td>20,800</td>
                <td>25,000</td>
                <td>20,801</td>
                <td>25,000</td>
            </tr>
            <tr>
                <td>2</td>
                <td>20,000</td>
                <td>20,000</td>
                <td>21,632</td>
                <td>25,000</td>
                <td>21,633</td>
                <td>25,000</td>
            </tr>
            <tr>
                <td>3</td>
                <td>20,000</td>
                <td>20,000</td>
                <td>22,497</td>
                <td>25,000</td>
                <td>22,498</td>
                <td>25,000</td>
            </tr>
            @endempty
        </tbody>
    </table>

    <div class="section-title bilingual">
        <span class="english">Notes</span>
        <span class="urdu">نوٹ</span>
    </div>

    <div class="bilingual">
        <span class="english">Allocation charges at the following rates, have been deducted from the contribution per year before the amount is allocated to the relevant fund:</span>
        <span class="urdu">مندرجہ ذیل شرحوں پر مختص چارجز، متعلقہ فنڈ میں رقم مختص کرنے سے پہلے ہر سال زرِ تکافل سے کاٹ لیے گئے ہیں</span>
    </div>

    <table style="width: 50%;">
        <thead>
            <tr>
                <th width="50%">
                    <div class="bilingual">
                        <span class="english">Year</span>
                    </div>
                </th>
                <th width="50%">
                    <div class="bilingual">
                        <span class="english">Allocation Charges (%)</span>
                    </div>
                </th>
            </tr>
        </thead>
        <tbody>
            @foreach($allocationCharges ?? [] as $charge)
            <tr>
                <td>{{ $charge['year'] ?? '' }}</td>
                <td>{{ $charge['rate'] ?? '' }}</td>
            </tr>
            @endforeach
            
            @empty($allocationCharges)
            <tr>
                <td>Year 1 and Onwards</td>
                <td>Nill</td>
            </tr>
            @endempty
        </tbody>
    </table>

    <div class="bilingual">
        <span class="english">The illustrative values do not take into account any partial surrenders.</span>
        <span class="urdu">اوپر دی گئی تصريحی ماليت کسی بھی قسم کی جزوی دستبرداری کو ظاہر نہيں کرتی.</span>
    </div>

    <div class="bilingual">
        <span class="english">Death Benefit is greater of Sum Covered or Cash Value.</span>
    </div>
    
    <div class="bilingual" style="margin-top: 15px;">
    <span class="english">Expected surrender values stated above are net of the following Wakalah fee:</span><br>
    <span class="urdu">اوپر دی گئی دستبرداری کی مالیت میں مندرجہ ذیل وکالہ فیس لاگو ہیں:</span>
</div>

<table style="width: 100%; margin-top: 10px; border-collapse: collapse;" border="1">
    <thead>
        <tr>
            <th>
                <div class="bilingual">
                    <span class="english">Accumulated Contribution</span><br>
                    <span class="urdu">جمع شدہ زرِتکافل</span>
                </div>
            </th>
            <th>
                <div class="bilingual">
                    <span class="english">Expected Rate of Return</span><br>
                    <span class="urdu">متوقع منافع کی شرح</span>
                </div>
            </th>
            <th>
                <div class="bilingual">
                    <span class="english">Variable Wakalah Fee</span><br>
                    <span class="urdu">متغیر وکالہ فیس</span>
                </div>
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>500 – 9,999</td>
            <td>9% - 9.99%</td>
            <td>6% - 6.99%</td>
        </tr>
        <tr>
            <td>10,000 – 49,999</td>
            <td>9% - 9.99%</td>
            <td>5% - 5.99%</td>
        </tr>
        <tr>
            <td>50,000 – 149,999</td>
            <td>9% - 9.99%</td>
            <td>4% - 4.99%</td>
        </tr>
        <tr>
            <td>150,000 – 200,000</td>
            <td>9% - 9.99%</td>
            <td>3% - 3.99%</td>
        </tr>
        <tr>
            <td>500 – 9,999</td>
            <td>13% - 13.99%</td>
            <td>8% - 8.99%</td>
        </tr>
        <tr>
            <td>10,000 – 49,999</td>
            <td>13% - 13.99%</td>
            <td>7% - 7.99%</td>
        </tr>
        <tr>
            <td>50,000 – 149,999</td>
            <td>13% - 13.99%</td>
            <td>6% - 6.99%</td>
        </tr>
        <tr>
            <td>150,000 – 200,000</td>
            <td>13% - 13.99%</td>
            <td>4% - 4.99%</td>
        </tr>
    </tbody>
</table>

</body>
</html>