<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CalendarManagementSeeder extends Seeder
{
    public function run()
    {
        $holidays = [
            ['holiday_date' => '2025-01-01', 'description' => "New Year's Day", 'status' => 'active'],
            ['holiday_date' => '2025-02-05', 'description' => "Kashmir Day", 'status' => 'active'],
            ['holiday_date' => '2025-03-23', 'description' => "Pakistan Day", 'status' => 'active'],
            ['holiday_date' => '2025-03-30', 'description' => "Eid-ul-Fitr (Tentative)", 'status' => 'active'],
            ['holiday_date' => '2025-03-31', 'description' => "Eid-ul-Fitr Holiday (Tentative)", 'status' => 'active'],
            ['holiday_date' => '2025-04-01', 'description' => "Eid-ul-Fitr Holiday (Tentative)", 'status' => 'active'],
            ['holiday_date' => '2025-05-01', 'description' => "Labour Day", 'status' => 'active'],
            ['holiday_date' => '2025-06-07', 'description' => "Eid al-Adha (Tentative)", 'status' => 'active'],
            ['holiday_date' => '2025-06-08', 'description' => "Eid al-Adha Holiday (Tentative)", 'status' => 'active'],
            ['holiday_date' => '2025-06-09', 'description' => "Eid al-Adha Holiday (Tentative)", 'status' => 'active'],
            ['holiday_date' => '2025-08-14', 'description' => "Independence Day", 'status' => 'active'],
            ['holiday_date' => '2025-09-05', 'description' => "Eid Milad-un-Nabi (Tentative)", 'status' => 'active'],
            ['holiday_date' => '2025-11-09', 'description' => "Iqbal Day", 'status' => 'active'],
            ['holiday_date' => '2025-12-25', 'description' => "Quaid-e-Azam Day / Christmas", 'status' => 'active'],
        ];

        // Generate all weekends (Saturdays and Sundays) for 2025
        $year = 2025;
        $startDate = Carbon::create($year, 1, 1);
        $endDate = Carbon::create($year, 12, 31);

        while ($startDate->lte($endDate)) {
            if ($startDate->isSaturday() || $startDate->isSunday()) {
                $holidays[] = [
                    'holiday_date' => $startDate->toDateString(),
                    'description' => $startDate->isSaturday() ? 'Weekend (Saturday)' : 'Weekend (Sunday)',
                    'status' => 'active',
                ];
            }
            $startDate->addDay();
        }

        // Insert all holidays into the table
        DB::table('calender_management')->insert(array_map(function ($holiday) {
            return [
                'holiday_date' => Carbon::parse($holiday['holiday_date']),
                'description' => $holiday['description'],
                'status' => $holiday['status'],
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }, $holidays));
    }
}
