<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBidPricesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
   public function up()
    {
        Schema::create('bid_prices', function (Blueprint $table) {
            $table->id(); // Laravel's auto-incrementing primary key
            $table->string('cfu_fundcode', 10); // Fund code (e.g., "010")
            $table->decimal('cbd_bidprice', 15, 5); // Bid price with up to 5 decimal places
            $table->decimal('cbd_offerprice', 15, 5); // Offer price
            $table->date('cbd_valuedate'); // Date value
            $table->timestamps(); // created_at and updated_at
        });
    }

    public function down()
    {
        Schema::dropIfExists('bid_prices');
    }
}
