<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePdfReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pdf_reports', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('msisdn');
            $table->decimal('amount', 10, 2);
            $table->string('contribution_term');
            $table->decimal('sum_covered', 10, 2);
            $table->decimal('profit_at_9', 10, 2);
            $table->decimal('profit_at_13', 10, 2);
            $table->string('pdf_path');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pdf_reports');
    }
}
