<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('insurance_data', function (Blueprint $table) {
            // Drop the existing foreign key constraint
           // $table->dropForeign(['customer_id']);

            // Add the new foreign key referencing easypaisa_users
            $table->foreign('customer_id')
                ->references('id')
                ->on('easypaisa_users')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('insurance_data', function (Blueprint $table) {
            // Drop the modified foreign key constraint
            $table->dropForeign(['customer_id']);

            // Restore the old foreign key if needed
            $table->foreign('customer_id')
                ->references('id')
                ->on('customer_information')
                ->onDelete('cascade');
        });
    }
};
