<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('temporary_savings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id');
            $table->string('customer_msisdn', 191);
            $table->string('customer_union_id', 200);
            $table->decimal('initial_deposit', 10, 2);
            $table->string('plan', 191);
            $table->string('activated_slab', 191);
            $table->integer('tenure_days');
            $table->string('saving_status')->default('payment_pending');
            $table->string('transaction_id', 191)->nullable();
            $table->timestamps();

            // Foreign Key Constraints (if needed)
            $table->foreign('customer_id')->references('id')->on('easypaisa_users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('temporary_savings');
    }
};

