<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('failed_savings_attempts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id');
            $table->string('customer_msisdn');
            $table->decimal('initial_deposit', 10, 2);
            $table->integer('tenure_days');
            $table->string('failure_reason');
            $table->string('transaction_id')->nullable();
            $table->string('saving_status')->default('failed');
            $table->timestamp('attempted_at')->useCurrent();
        });
    }

    public function down()
    {
        Schema::dropIfExists('failed_savings_attempts');
    }
};
