<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('investment_ledger_saving', function (Blueprint $table) {
            $table->unsignedBigInteger('saving_id')->after('customer_id'); // Ensure the column exists in the correct position
            $table->foreign('saving_id')
                  ->references('id')
                  ->on('customer_savings_master')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::table('investment_ledger_saving', function (Blueprint $table) {
            $table->dropForeign(['saving_id']);
            $table->dropColumn('saving_id');
        });
    }
};
