<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('daily_returns', function (Blueprint $table) {
            $table->decimal('todays_interest_rate', 5, 2)->nullable()->after('type')->comment("Today's calculated interest rate");
            $table->decimal('easypaisa_share_percentage', 5, 2)->nullable()->after('todays_interest_rate')->comment('Easypaisa share percentage');
            $table->decimal('efu_share_percentage', 5, 2)->nullable()->after('easypaisa_share_percentage')->comment('EFU share percentage');
            $table->decimal('customer_share_percentage', 5, 2)->nullable()->after('efu_share_percentage')->comment('Customer share percentage');
        });
    }

    public function down()
    {
        Schema::table('daily_returns', function (Blueprint $table) {
            $table->dropColumn([
                'todays_interest_rate',
                'easypaisa_share_percentage',
                'efu_share_percentage',
                'customer_share_percentage'
            ]);
        });
    }
};
