<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('customer_savings_master', function (Blueprint $table) {
            $table->integer('tenure_days')->nullable()->after('saving_end_date')->comment('Total Tenure in Days');
            $table->integer('active_days')->nullable()->after('tenure_days')->comment('Active Days Calculation');
            $table->enum('maturity_status', ['matured', 'in-progress', 'terminated'])->default('in-progress')->after('active_days')->comment('Status of the Saving');
            $table->timestamp('last_profit_calculated_at')->nullable()->after('maturity_status')->comment('Last Profit Calculation Time');
        });
    }

    public function down()
    {
        Schema::table('customer_savings_master', function (Blueprint $table) {
            $table->dropColumn(['tenure_days', 'active_days', 'maturity_status', 'last_profit_calculated_at']);
        });
    }
};
