<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('daily_returns', function (Blueprint $table) {
            // Add saving_id and investment_ledger_saving_id columns
            //
            $table->unsignedBigInteger('investment_ledger_saving_id')->after('saving_id');

            // Define foreign key constraint for saving_id
            //

            // Define foreign key constraint for investment_ledger_saving_id
            $table->foreign('investment_ledger_saving_id')
                ->references('id')
                ->on('investment_ledger_saving')
                ->onDelete('cascade'); // Adjust as per business logic
        });
    }

    public function down()
    {
        Schema::table('daily_returns', function (Blueprint $table) {
            // Drop foreign keys first
            // $table->dropForeign(['saving_id']);
            $table->dropForeign(['investment_ledger_saving_id']);

            // Drop the columns
            $table->dropColumn(['investment_ledger_saving_id']);
        });
    }
};
