<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('insurance_data', function (Blueprint $table) {
            // Add foreign key column for `saving_id`
            $table->unsignedBigInteger('saving_id')->after('customer_id'); // Adjust position as needed

            // Define foreign key constraint
            $table->foreign('saving_id')
                ->references('id')
                ->on('customer_savings_master')
                ->onDelete('cascade'); // Adjust the deletion behavior as per business logic
        });
    }

    public function down()
    {
        Schema::table('insurance_data', function (Blueprint $table) {
            // Drop foreign key first
            $table->dropForeign(['saving_id']);

            // Drop the column
            $table->dropColumn('saving_id');
        });
    }
};
