<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('calender_management', function (Blueprint $table) {
            $table->enum('holiday_type', ['Weekend', 'Public Holiday', 'Bank Holiday'])->after('description')->default('Public Holiday');
            $table->boolean('is_national_holiday')->default(false)->after('holiday_type');
            $table->boolean('is_repeated')->default(false)->after('is_national_holiday');
            $table->date('effective_from')->nullable()->after('is_repeated');
            $table->date('effective_to')->nullable()->after('effective_from');
            $table->enum('status', ['Active', 'Inactive'])->default('Active')->after('effective_to');
        });
    }

    public function down()
    {
        Schema::table('calender_management', function (Blueprint $table) {
            $table->dropColumn(['holiday_type', 'is_national_holiday', 'is_repeated', 'effective_from', 'effective_to', 'status']);
        });
    }
};
