<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('beneficiaries', function (Blueprint $table) {
            $table->decimal('beneficiary_percentage', 5, 2)->after('relationship')->default(0.00);
            $table->string('title_of_bank')->after('contact_number')->nullable();
        });
    }

    public function down()
    {
        Schema::table('beneficiaries', function (Blueprint $table) {
            $table->dropColumn(['beneficiary_percentage', 'title_of_bank']);
        });
    }
};
