<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('beneficiaries', function (Blueprint $table) {
            $table->date('cnic_expiry_date')->nullable()->after('cnic');
            $table->string('nationality', 50)->nullable()->after('cnic_expiry_date');
            $table->enum('beneficiary_type', ['Primary', 'Secondary', 'Dependent'])->nullable()->after('nationality');
            $table->string('policy_number')->nullable()->after('beneficiary_type');
            $table->string('nominee_name')->nullable()->after('policy_number');
            $table->string('nominee_relationship')->nullable()->after('nominee_name');
            $table->string('bank_name')->nullable()->after('nominee_relationship');
            $table->string('account_number')->nullable()->after('bank_name');
            $table->string('iban')->nullable()->after('account_number');
            $table->unsignedBigInteger('insurance_id')->nullable()->after('iban');

            // Foreign key constraint linking to insurance_data table
            $table->foreign('insurance_id')->references('id')->on('insurance_data')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('beneficiaries', function (Blueprint $table) {
            $table->dropForeign(['insurance_id']);
            $table->dropColumn([
                'cnic_expiry_date', 'nationality', 'beneficiary_type', 
                'policy_number', 'nominee_name', 'nominee_relationship', 
                'bank_name', 'account_number', 'iban', 'insurance_id'
            ]);
        });
    }
};
