<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('customer_savings_master', function (Blueprint $table) {
            $table->decimal('fund_growth_amount', 10, 2)->default(0)->after('activated_slab');
        });
    }

    public function down(): void
    {
        Schema::table('customer_savings_master', function (Blueprint $table) {
            $table->dropColumn('fund_growth_amount');
        });
    }
};

