<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('investment_ledger_saving', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id');
            $table->decimal('amount', 15, 2);
            $table->enum('transaction_type', ['deposit', 'withdrawal', 'profit']);
            $table->timestamp('date_time')->useCurrent();
            $table->decimal('net_amount', 15, 2);
            $table->decimal('gross_amount', 15, 2);
            $table->timestamps();

            // Foreign key constraint (if customer_id exists in another table)
            $table->foreign('customer_id')->references('id')->on('easypaisa_users')->onDelete('cascade');
        });
    }

    public function down() {
        Schema::dropIfExists('investment_ledger_saving');
    }
};

