<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('customer_savings_master', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->unsignedBigInteger('customer_id'); // Foreign key reference
            $table->string('customer_msisdn', 15); // Customer MSISDN (Mobile Number)
            $table->string('customer_union_id')->unique(); // Unique identifier for customer across systems

            // Saving details
            $table->decimal('initial_deposit', 12, 2); // Initial deposit amount
            $table->string('plan'); // Plan type (e.g., "Basic", "Premium", etc.)
            $table->string('activated_slab')->nullable(); // Slab or tier activated

            // Saving status
            $table->enum('saving_status', ['on-going', 'tenure_complete', 'cancelled'])->default('on-going');

            // Timestamps
            $table->timestamp('saving_start_date')->useCurrent(); // Saving start date and time
            $table->timestamp('saving_end_date')->nullable(); // Completion/cancellation date

            $table->timestamps();

            // Foreign key constraint
            $table->foreign('customer_id')->references('id')->on('easypaisa_users')->onDelete('cascade');

            // Indexing for performance
            $table->index(['customer_id', 'saving_status']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('customer_savings_master');
    }
};

