<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('monthly_summaries', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->unsignedBigInteger('customer_id'); // Foreign key reference
            $table->year('year'); // Year of the summary
            $table->tinyInteger('month'); // Month of the summary
            
            // Financial calculations (Aggregated)
            $table->decimal('total_earned', 12, 2)->default(0.00); // Total profit earned
            $table->decimal('fund_growth_amount', 12, 2)->default(0.00); // Fund growth
            $table->decimal('efu_share', 12, 2)->default(0.00); // EFU's share
            $table->decimal('easypaisa_share', 12, 2)->default(0.00); // Easypaisa's share
            $table->decimal('customer_share', 12, 2)->default(0.00); // Customer's share
            
            // Insurance-related fields
            $table->decimal('sum_assured', 12, 2)->default(0.00); // Sum assured
            $table->decimal('sum_at_risk', 12, 2)->default(0.00); // Sum at risk
            $table->decimal('mortality_charges', 12, 2)->default(0.00); // Mortality charges
            
            // Profit-sharing details
            $table->decimal('ptf_share', 12, 2)->default(0.00); // PTF share
            $table->decimal('osf_share', 12, 2)->default(0.00); // OSF share

            $table->decimal('withdrawn', 12, 2)->default(0.00); // Total withdrawn amount for the month
            $table->decimal('final_balance', 12, 2)->default(0.00); // Balance at the end of the month

            $table->enum('type', ['profit', 'adjustment'])->default('profit'); // Type of entry

            $table->timestamps();

            // Unique constraint to ensure only one summary per customer per month
            $table->unique(['customer_id', 'year', 'month']);

            // Foreign key constraint
            $table->foreign('customer_id')->references('id')->on('easypaisa_users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('monthly_summaries');
    }
};
