<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('daily_returns', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->date('date')->index(); // Indexed for fast queries
            $table->unsignedBigInteger('customer_id'); // Foreign key reference
            $table->decimal('amount_earned', 12, 2)->default(0.00);
            $table->decimal('commulative_amount', 12, 2)->default(0.00);
            $table->decimal('fund_growth_amount', 12, 2)->default(0.00);
            $table->decimal('efu_share', 12, 2)->default(0.00);
            $table->decimal('easypaisa_share', 12, 2)->default(0.00);
            $table->decimal('customer_share', 12, 2)->default(0.00);
            $table->decimal('sum_assured', 12, 2)->default(0.00);
            $table->decimal('sum_at_risk', 12, 2)->default(0.00);
            $table->decimal('mortality_charges', 12, 2)->default(0.00);
            $table->decimal('ptf_share', 12, 2)->default(0.00);
            $table->decimal('osf_share', 12, 2)->default(0.00);
            $table->enum('type', ['profit', 'charge', 'deduction'])->default('profit'); 
            $table->timestamps(); // Created_at and updated_at

            // Foreign key constraint (Assuming `easypaisa_users` table exists)
            $table->foreign('customer_id')->references('id')->on('easypaisa_users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('daily_returns');
    }
};

