<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('beneficiaries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('easypaisa_customer_id');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('cnic', 15)->unique();
            $table->date('date_of_birth')->nullable();
            $table->enum('gender', ['Male', 'Female', 'Other'])->nullable();
            $table->string('relationship'); // e.g., Spouse, Child, Parent
            $table->string('contact_number')->nullable();
            $table->text('address')->nullable();
            $table->timestamps();

            // Foreign key to link beneficiaries to easypaisa_customers
            $table->foreign('easypaisa_customer_id')->references('id')->on('easypaisa_users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('beneficiaries');
    }
};