<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use DateTime;
use DateTimeZone;



class EasypaisaPaymentService
{
    
protected string $publicKeyPem = <<<EOD
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAn5jTUtv5E+0q4Z5Z5rm2
i3J9efGnTK8HpG4kDeX6vWeHyFysb/VcthL75leqyQgfxPOVxBaqzRJk9+NtFzz7
IC/mBIKoL5hvp/Ehnc2YOmYG+V/nQfQDFjq701U9hHjaws9q1gIXA0LeiZYeiMFN
zAMKqWO4xltaJGXi/MtHeMrMe69neqq7Vla+VEVTclFkZXzX6yMXep8ZmO+VGiQv
+NPG9r2V1/R7WiuLeWUj+r1j/tuqevVPy9r6Lor/tEa4PrZDoGDa/7UXKjaQo4In
BHy8L+0vZPurILv2vATXNZxJ2ThOD5Or2FiwMd2iEMROcdlT8Diit7vRLofmtC45
9QIDAQAB
-----END PUBLIC KEY-----
EOD;

protected string $privateKeyPem = <<<EOD
-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCfmNNS2/kT7Srh
nlnmubaLcn158adMrwekbiQN5fq9Z4fIXKxv9Vy2EvvmV6rJCB/E85XEFqrNEmT3
420XPPsgL+YEgqgvmG+n8SGdzZg6Zgb5X+dB9AMWOrvTVT2EeNrCz2rWAhcDQt6J
lh6IwU3MAwqpY7jGW1okZeL8y0d4ysx7r2d6qrtWVr5URVNyUWRlfNfrIxd6nxmY
75UaJC/408b2vZXX9HtaK4t5ZSP6vWP+26p69U/L2vouiv+0Rrg+tkOgYNr/tRcq
NpCjgicEfLwv7S9k+6sgu/a8BNc1nEnZOE4Pk6vYWLAx3aIQxE5x2VPwOKK3u9Eu
h+a0Ljn1AgMBAAECggEARQTcbvr+bqWkY8oNawBpd0jeBryA82LGVU/ke7Y3h22c
hQO+9vQPUhZHpcfH7gR7aLtGy3RaDTGlRKav6NrQZ40PVmgCwAKWVvSq6wmcibTR
00qsQhN6ukRQMgatAfsZ8CGvPDnPJfPnNW0ca1vdfxrZo4OixvV+uDrvvQ9UK2Ip
o8OjHbTYlF/Kb15vSedMbdB3MD1P3y90biCFRkBBuGTjZE5Lv/VYk35EYUJa1bW7
GAOLHmSd8a8TILrRSynIovJ2N6T1swB5jxbPb0RdOtWK4RFOFaUvQq3113bKInvH
Q5nGQAXYwGpP5E+UEGUzGI6RCflE1GsVfa42P4TTAQKBgQDTwWWLvAz3luBrWiiO
3VXVEWbs3TCW8ApvqxVYOTo4ZZewRPonxJ9JLPqsnD/E0PvbtKAGQZ7+ZqFnfl7G
yh8NOLIRKqPmz7rO3bPabXLX7J7S6X1wM4SXLKAC52+4rYWtOYqJNfn98E+6EWBD
jJStd5Kd7tGBE2+P8aqZwbh41QKBgQDA8YUalLAGnR3/KabZ7os/EspXzL72I/Ds
76shKOhOLFSkGM8wmQpdnYxH6p2qh6vPmFcuNJtE7YQ/I5dGknB42agghTWP6Jnd
No7mpJVrY+6NPwc2RQAFYFNxkYTvxIjpZ+cN+q0zXmM/cocoNofvePg0L2ArSpZp
qROtU59MoQKBgCL6zZV5qQK1T7ksGYsQEP+zcjcqir5ERNURg+MhAPcUASzDGDe9
iTqDTZ156ibPBuvSOKUP7f3EYmFARNO9y8dZWEDxtEWKhydpBC7O6au1kL7yhyAj
woFeg8g3BwOQ1oY4/SORYQyLx//KowZFkMHfAL9KFh2mYkV6/F2N3LVJAoGAbHVX
xSFf8dfQTOc1C7y0ObhuVfyaO/LoM8hmAjXkoEz7J2Nq1H6y/PzbJnIUPxAU3JVe
LHMV9SEu/e8b0mfvIX/4qo83FLZEB73rhmtuMvfx2SRdAXy4Dk2fmm+ass1fyRTH
JWyMgBvG3puarlg5AbyWiX84KB29f5ezn/Mp0QECgYEAgDWbZpf+g2kqWgVWoEia
Oo4et0VqKgHqqHqxLYwyyGx9BLCATmKCgmtmA4irp2wR9E+dt6uW6Tbi/0EUtVMJ
Rfw7kqj51HeziDkm3LNOSWppHLrWg8ywO90BYPTIZDebVugE4oaP9L8P7pQBpNXj
xSVFQ3Gz9Sv/0kGODpThQdU=
-----END PRIVATE KEY-----
EOD;


    private string $clientId;
    private string $apiKey;
    private string $baseUrl;
    private string $appId;
    private string $merchantId;
    private string $accessToken;
    private $privateKey;
    private $publicKey;

    public function __construct()
    {
        $this->clientId     = config('easypaisa.client_id');
        $this->apiKey       = config('easypaisa.api_key');
        $this->baseUrl      = config('easypaisa.base_url');
        $this->appId        = config('easypaisa.app_id');
        $this->merchantId   = config('easypaisa.merchant_id');
        $this->accessToken  = config('easypaisa.access_token');
        $this->privateKey   = openssl_pkey_get_private(config('easypaisa.private_key'));

        if (!$this->privateKey) {
            Log::error("EasypaisaController: Invalid private key loaded.");
        }
        
        $this->publicKey    = openssl_pkey_get_public(config('easypaisa.public_key'));
        
        if (!$this->publicKey) {
            Log::error("EasypaisaService: Invalid public key loaded.");
        }
    }

    private function generateSignature($data)
    {
       // return $data;
        $privateKey = openssl_pkey_get_private($this->privateKey);
        if (!$privateKey) {
            Log::error("Error loading private key.");
            return false;
        }

        openssl_sign($data, $signature, $privateKey, OPENSSL_ALGO_SHA256);
        openssl_free_key($privateKey);

        return urlencode(base64_encode($signature));
    }

    private function sendRequest($endpoint, $headers, $data)
    {

          // Log the request data
        $url = $this->baseUrl . $endpoint;

        $response = Http::withHeaders([
            "Request-Time"  => $headers['Request-Time'],
            "Client-Id"     => $headers['Client-Id'],
            "Signature"     => $headers['Signature'],
            "Access-Token"  => $headers['Access-Token'],
            "Content-Type"  => "application/json"
        ])->post($url, $data);

        return $response->json();
    }

    public function createPaymentservice($savingId, $amount)
    {
        $date = new DateTime('now', new DateTimeZone('Asia/Karachi'));
        $requestTime = $date->format("Y-m-d\TH:i:s.vP");
         $adjustedAmount = ceil($amount) * 100;

        $data = [
                "merchantID" => $this->merchantId,                // from constructor
                "appID" => $this->appId,                          // from constructor
                "paymentOrderTitle" => "EFU-Saving-" . $savingId, // descriptive title
                "paymentOrderID" => (string) $savingId,           // important for consistency
                "paymentAmount" => [
                    "currency" => "PKR",
                    "value" => (string) $adjustedAmount            // must be string for most APIs
                ]
                ];

        $signatureString = "POST /v1/payments/createPayment\n" .
            "{$this->clientId}.{$requestTime}.{$this->accessToken}." . json_encode($data);

        $signature = $this->generateSignature($signatureString);
        if (!$signature) {
            return ['error' => 'Failed to generate signature'];
        }

        $params = [
            "Request-Time" => $requestTime,
            "Client-Id" => $this->clientId,
            "Access-Token" => $this->accessToken,
        ];
        //return $data;
        //$signature = $this->generateSignature($signatureString);
        $params['Signature'] = "algorithm=RSA2048, keyVersion=1, signature=$signature";
        $response = $this->sendRequest('/v1/payments/createPayment', $params, $data);


        return response()->json($response);
    }

    public function handlePaymentResponse($request)
    {
        DB::beginTransaction();
        try {
            $savingTempId = $request->paymentOrderID;
            $paymentStatus = $request->paymentStatus;
            $failureReason = $request->failureReason ?? 'Unknown error';

            if ($paymentStatus === 'success') {
                $savingData = DB::table('customer_savings_master_temp')->where('id', $savingTempId)->first();
                if (!$savingData) {
                    return response()->json(['error' => 'Invalid saving ID'], 400);
                }

                $savingId = DB::table('customer_savings_master')->insertGetId((array) $savingData);

                DB::table('investment_ledger_saving')->insert([
                    'customer_id' => $savingData->customer_id,
                    'saving_id' => $savingId,
                    'transaction_id' => $request->transaction_id,
                    'amount' => $savingData->initial_deposit,
                    'transaction_type' => 'deposit',
                    'date_time' => now(),
                    'net_amount' => $savingData->initial_deposit,
                    'gross_amount' => $savingData->initial_deposit,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                DB::table('customer_savings_master_temp')->where('id', $savingTempId)->delete();
                DB::commit();
                return response()->json(['message' => 'Saving successfully started!', 'saving_id' => $savingId], 201);
            } else {
                $savingData = DB::table('customer_savings_master_temp')->where('id', $savingTempId)->first();
                if ($savingData) {
                    DB::table('failed_savings_attempts')->insert([
                        'customer_id' => $savingData->customer_id,
                        'customer_msisdn' => $savingData->customer_msisdn,
                        'initial_deposit' => $savingData->initial_deposit,
                        'tenure_days' => $savingData->tenure_days,
                        'failure_reason' => $failureReason,
                        'transaction_id' => $request->transaction_id ?? null,
                        'saving_status' => 'failed',
                        'attempted_at' => now(),
                    ]);
                }
                DB::table('customer_savings_master_temp')->where('id', $savingTempId)->delete();
                DB::commit();
                return response()->json(['error' => 'Payment Failed. Saving attempt logged.'], 400);
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'Something went wrong!', 'details' => $e->getMessage()], 500);
        }
    }
    
    
    //New Implmentation Based on Ramsha Code 
  


      
    public function initiateCashDeposit($savingId, $amount, $userMsisdn, $merchantMsisdn, $openId, $transactionDesc = '')
{
    $requestTime = now('Asia/Karachi')->format("Y-m-d\TH:i:s.vP");
    $adjustedAmount = ceil($amount) * 100; // Convert to paisa
    $orderId = "test" . $savingId;

    // Step 1: Generate random AES seed
    $seed = $this->getRandomString(32);
    //return $seed;

    // Step 2: Encrypt credentials using AES with SHA-1 derived key
    $credentials = "AzeemIqbalPirani7041:Telenor@321";
    $encryptedCredentials = $this->aesEncryptWithSha1($seed, $credentials);
 
    
 
    // Step 3: Encrypt AES seed with Easypaisa's public key
    $rsaEncryptedKey = $this->rsaEncryptWithPrivateKey($seed, $this->privateKeyPem);
    if (!$rsaEncryptedKey) {
        return ['error' => 'Failed to encrypt AES key'];
    }

    // Step 4: URL encode RSA-encrypted key
    $encodedKey = urlencode($rsaEncryptedKey);
    
    // Step 5: Prepare request body
    $data = [
        "merchantId" => $this->merchantId,
        "appId" => $this->appId,
        "paymentAmount" => [
            "currency" => "PKR",
            "value" => (string) $adjustedAmount
        ],
        "orderId" => $orderId,
        "credentials" => $encryptedCredentials,
        "merchantMsisdn" => $merchantMsisdn,
        "msisdn" => $userMsisdn,
        "openId" => $openId,
        "transactionDesc" => $transactionDesc
    ];

    // Step 6: Generate signature string
    $signatureString = "POST /v1/payments/cashDeposit\n" .
        "{$this->clientId}.{$requestTime}.{$this->accessToken}." . json_encode($data);

    $signature = $this->generateSignature($signatureString);
    if (!$signature) {
        return ['error' => 'Failed to generate signature'];
    }

    // Step 7: Build headers
    $headers = [
        "Signature" => "algorithm=RSA2048, keyVersion=1, signature=$signature",
        "Client-Id" => $this->clientId,
        "Request-Time" => $requestTime,
        "Access-Token" => $this->accessToken,
        "Encrypt" => "algorithm=RSA_AES, keyVersion=1, symmetricKey=$encodedKey"
    ];
    
    //return $headers;

    // Logging
    Log::debug("🔁 CashDeposit Request Initialized:\n" .
    "📅 Request-Time: {$requestTime}\n" .
    "🆔 Order-ID: {$orderId}\n" .
    "🔑 AES-Key-Seed: {$seed}\n" .
    "🔐 Encrypted-Credentials: {$encryptedCredentials}\n" .
    "🔒 RSA-Encrypted-Key: " . base64_encode($rsaEncryptedKey) . "\n" .
    "✍️ Signature-String: {$signatureString}\n" .
    "📦 Headers: " . json_encode($headers, JSON_PRETTY_PRINT) . "\n" .
    "📨 Request-Body: " . json_encode($data, JSON_PRETTY_PRINT)
);

    // Send API request
    $response = $this->sendRequestCashDesposit('/v1/payments/cashDeposit', $headers, $data);
    return response()->json($response);
}




private function generateSecretKey(string $seed): string
{
    $btLength = 16;
    $bt = '';
    $index = 0;
    $digestSize = 20;
    $state = sha1($seed, true);

    while ($index < $btLength) {
        $output = sha1($state, true);
        $todo = min($btLength - $index, $digestSize);
        for ($i = 0; $i < $todo; $i++) {
            $bt .= $output[$i];
            $index++;
        }
    }

    return substr($bt, 0, 16);
}

private function aesEncryptWithSha1($seed, $plainText)
{
    $key = $this->generateSecretKey($seed);
    $cipher = 'AES-128-ECB';
    $options = OPENSSL_RAW_DATA;

    $encrypted = openssl_encrypt($plainText, $cipher, $key, $options);
    return base64_encode($encrypted);
}


private function rsaEncryptWithPrivateKey($data, $privateKeyPem)
{
    $privateKey = openssl_pkey_get_private($privateKeyPem);
    if (!$privateKey) {
        throw new Exception("Invalid private key");
    }

    $chunkSize = 245; // for RSA 2048 with PKCS1 padding
    $output = '';

    foreach (str_split($data, $chunkSize) as $chunk) {
        $encrypted = '';
        if (!openssl_private_encrypt($chunk, $encrypted, $privateKey, OPENSSL_PKCS1_PADDING)) {
            throw new Exception('RSA encryption failed: ' . openssl_error_string());
        }
        $output .= $encrypted;
    }

    return base64_encode($output);
}

private function getRandomString($length = 32)
{
    $chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $result = '';
    for ($i = 0; $i < $length; $i++) {
        $result .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $result;
}


    private function sendRequestCashDesposit($endpoint, $headers, $data)
    {

          // Log the request data
        $url = $this->baseUrl . $endpoint;

        $response = Http::withHeaders([
            "Request-Time"  => $headers['Request-Time'],
            "Client-Id"     => $headers['Client-Id'],
            "Signature"     => $headers['Signature'],
            "Access-Token"  => $headers['Access-Token'],
            "Encrypt"       => $headers['Encrypt'],
            "Content-Type"  => "application/json"
        ])->post($url, $data);

        return $response->json();
    }


}
