<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use DateTime;
use DateTimeZone;
use App\Models\CustomerSavingsMaster;
use App\Models\InvestmentLedgerSaving;
use App\Models\KiborRate;
use App\Models\Slab;
use App\Models\DailyReturn;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\BidPrice;


class WithdrawSavingController extends Controller
{
    protected $merchantId = 'savingsapp';
    protected $appId = 'savingsapp';
    protected $clientId = '06162633350408';
    protected $accessToken = '9d5a1bf90ce07045799d4b27341022b72e5b8735';
    protected $baseUrl = 'https://miniapp-epdev.telenorbank.pk'; // Replace with your actual base URL
    protected $publicKey = "-----BEGIN PUBLIC KEY-----\n".
    "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqK7nJ9pZy6iMZhzqWzTeZ
    +M0J+T3yLXe9xZQ4JXh5LRR4dBfQEgO2uOuOf4cD/AYd1J/2ujL0JmOzy5jwfo9l
    Nl7l4FUBztoerE5NQhJHBL9HZpext0jfy50zA6HrqC+0scwWwq7VJ9uo/KtBf6ndX
    VJeKLfVr/1pFbM6wr98hDtV5HCUlXZGpPt4OUgqlsBBL88mlQ0p4BLFZ9kfr0aEO
    gbh0fiM1uy4lg3A1OB26I+xtsj5CCB6cYnJHgr1f3+U4k5r7ZLUwX6Tw2SwvSvrj
    gnmrn6NmaBq9xwSIsq6VfE9TXnfo1CHn2Ae7F1T+qG6T7gd/MzkrQAvUR+a42z+m
    IQIDAQAB=\n".
    "-----END PUBLIC KEY-----";

    protected $privateKey = "-----BEGIN PRIVATE KEY-----\n" .
                            "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCfmNNS2/kT7SrhnlnmubaLcn158adMrwekbiQN5fq9Z4fIXKxv9Vy2EvvmV6rJCB/E85XEFqrNEmT3420XPPsgL+YEgqgvmG+n8SGdzZg6Zgb5X+dB9AMWOrvTVT2EeNrCz2rWAhcDQt6Jlh6IwU3MAwqpY7jGW1okZeL8y0d4ysx7r2d6qrtWVr5URVNyUWRlfNfrIxd6nxmY75UaJC/408b2vZXX9HtaK4t5ZSP6vWP+26p69U/L2vouiv+0Rrg+tkOgYNr/tRcqNpCjgicEfLwv7S9k+6sgu/a8BNc1nEnZOE4Pk6vYWLAx3aIQxE5x2VPwOKK3u9Euh+a0Ljn1AgMBAAECggEARQTcbvr+bqWkY8oNawBpd0jeBryA82LGVU/ke7Y3h22chQO+9vQPUhZHpcfH7gR7aLtGy3RaDTGlRKav6NrQZ40PVmgCwAKWVvSq6wmcibTR00qsQhN6ukRQMgatAfsZ8CGvPDnPJfPnNW0ca1vdfxrZo4OixvV+uDrvvQ9UK2Ipo8OjHbTYlF/Kb15vSedMbdB3MD1P3y90biCFRkBBuGTjZE5Lv/VYk35EYUJa1bW7GAOLHmSd8a8TILrRSynIovJ2N6T1swB5jxbPb0RdOtWK4RFOFaUvQq3113bKInvHQ5nGQAXYwGpP5E+UEGUzGI6RCflE1GsVfa42P4TTAQKBgQDTwWWLvAz3luBrWiiO3VXVEWbs3TCW8ApvqxVYOTo4ZZewRPonxJ9JLPqsnD/E0PvbtKAGQZ7+ZqFnfl7Gyh8NOLIRKqPmz7rO3bPabXLX7J7S6X1wM4SXLKAC52+4rYWtOYqJNfn98E+6EWBDjJStd5Kd7tGBE2+P8aqZwbh41QKBgQDA8YUalLAGnR3/KabZ7os/EspXzL72I/Ds76shKOhOLFSkGM8wmQpdnYxH6p2qh6vPmFcuNJtE7YQ/I5dGknB42agghTWP6JndNo7mpJVrY+6NPwc2RQAFYFNxkYTvxIjpZ+cN+q0zXmM/cocoNofvePg0L2ArSpZpqROtU59MoQKBgCL6zZV5qQK1T7ksGYsQEP+zcjcqir5ERNURg+MhAPcUASzDGDe9iTqDTZ156ibPBuvSOKUP7f3EYmFARNO9y8dZWEDxtEWKhydpBC7O6au1kL7yhyAjwoFeg8g3BwOQ1oY4/SORYQyLx//KowZFkMHfAL9KFh2mYkV6/F2N3LVJAoGAbHVXxSFf8dfQTOc1C7y0ObhuVfyaO/LoM8hmAjXkoEz7J2Nq1H6y/PzbJnIUPxAU3JVeLHMV9SEu/e8b0mfvIX/4qo83FLZEB73rhmtuMvfx2SRdAXy4Dk2fmm+ass1fyRTHJWyMgBvG3puarlg5AbyWiX84KB29f5ezn/Mp0QECgYEAgDWbZpf+g2kqWgVWoEiaOo4et0VqKgHqqHqxLYwyyGx9BLCATmKCgmtmA4irp2wR9E+dt6uW6Tbi/0EUtVMJRfw7kqj51HeziDkm3LNOSWppHLrWg8ywO90BYPTIZDebVugE4oaP9L8P7pQBpNXjxSVFQ3Gz9Sv/0kGODpThQdU=\n" .
                            "-----END PRIVATE KEY-----";

    public function cashDepositRequest(Request $request)
{
    $requestData = $request->all();

    // 1. Prepare payload
    $payload = [
        "merchantId" => $this->merchantId,
        "appId" => $this->appId,
        "paymentAmount" => [
            "currency" => "PKR",
            "value" => $requestData['amount']
        ],
        "orderId" => $requestData['orderId'],
        "credentials" => $this->aesEncrypt('teststore:Pakistan@123'), // Encrypted credentials
        "extendInfo" => $requestData['extendInfo'] ?? '',
        "merchantMsisdn" => $requestData['merchantMsisdn'],
        "msisdn" => $requestData['msisdn'],
        "openId" => $requestData['openId'],
        "transactionDesc" => $requestData['transactionDesc'] ?? ''
    ];

    // 2. Generate headers
    //$requestTime = now()->format('Y-m-d\TH:i:s\Z');
    $dataToSign = json_encode($payload, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

    $signature = $this->generateSignatureCashDeposit($dataToSign);
    $encryptHeader = $this->generateEncryptHeader();

    //return $encryptHeader;
    $date = new DateTime('now', new DateTimeZone('Asia/Karachi')); // Set to Pakistan Time (UTC+5)
    $requestTime = $date->format("Y-m-d\TH:i:s.vP");

    $headers = [
        "Request-Time" => $requestTime,
        "Client-Id" => $this->clientId,
        "Signature" => $signature,
        "Access-Token" => $this->accessToken,
        "Encrypt" => "algorithm=RSA_AES,keyVersion=1,symmetricKey=nysKMSR01HhHDZFm0WMZ%2BLg%2BiPyze%2FYtYq9XCNZLjTJ7WVjCdUVTDF6euM6rIO9UitAM28R6TkrANV23cjVaoUh5np96mFjhW%2F5sbbH9ZjC0QrvWTchiZpBIJHvFT5TJD9ca27CHgF6yDv7geL79W7XYoT%2FWLUyuy9UUcDZMdLVbpQnPGj1KM3M7p6z7q%2FXMQZtWklbIPTxdZeXVoNGsj7EIuWKhPxjC9Tlbx5yv5b08jkqHEj%2FFWUlkLdBGqH0v19l1d9DV5Jpo5Zk6k1SQLck2tpZh94me%2FWVLmlKFVMxSRKkdJNcpyuaIs80JPUpJBs4nB%2FRtDLI7Gt%2FsS79K%2BA%3D%3D",
        "Content-Type" => "application/json"
    ];

    // 3. Send Request
    $endpoint = '/v1/payments/cashDeposit';

    try {
       
        echo json_encode([
            'request_headers' => $headers,
            'request_payload' => $payload
        ], JSON_PRETTY_PRINT);
   

        $response = Http::withHeaders($headers)->post($this->baseUrl . $endpoint, $payload);
        return response()->json($response->json(), $response->status());
    } catch (\Exception $e) {
        Log::error('Cash Deposit Request Error: ' . $e->getMessage());
        return response()->json(['error' => 'Request failed', 'details' => $e->getMessage()], 500);
    }
}




public function dailyprofit(Request $request)
{
    // Get all active savings accounts
    $customerSavings = CustomerSavingsMaster::with('customer')
        ->where('saving_status', 'on-going')
        ->where('maturity_status', 'in-progress')
        ->get();

    // Get current policy rate (cache this if it doesn't change often)
    $policyRate = KiborRate::where('effective_date', '<=', now())
        ->orderBy('effective_date', 'desc')
        ->first()->kibor_rate ?? 0;
        
        
    $fundCode = '010';
    
    // Use Carbon for date handling
    $today = Carbon::today();
    $yesterday = $today->copy()->subDay();
    
    // Use caching for repeated queries (optional but efficient if reused)
    $bidPrices = BidPrice::where('cfu_fundcode', $fundCode)
    ->whereIn('cbd_valuedate', [$today->toDateString(), $yesterday->toDateString()])
    ->get()
    ->keyBy(function ($item) {
        return Carbon::parse($item->cbd_valuedate)->toDateString(); // Normalize key
    });
    
   
    
    // Assign today's and yesterday's bid prices
    $currentBidPrice = $bidPrices[$today->toDateString()]->cbd_bidprice ?? 0;
    $previousBidPrice = $bidPrices[$yesterday->toDateString()]->cbd_bidprice ?? 0;
    
 
    // Skip processing if bid data is incomplete
    if (!$currentBidPrice || !$previousBidPrice) {
        return response()->json(['message' => 'Bid price data missing for today or yesterday'], 404);
    }

    $results = [];
    DB::beginTransaction();

    try {
        foreach ($customerSavings as $saving) {
            // Get appropriate slab rate
            $slab = Slab::where('initial_deposit', '<=', $saving->fund_growth_amount)
                ->where('maximum_deposit', '>=', $saving->fund_growth_amount)
                ->first();

            $slabRate = $slab->daily_return_rate ?? 0;

            // Calculate daily rates
            $fundGrowthRate = round(pow(1 + ($policyRate / 100), 1 / 365) - 1, 8);
            $customerReturnRate = round(pow(1 + ($slabRate / 100), 1 / 365) - 1, 8);
            $efuLifeRate = round(pow(1 + (1 / 100), 1 / 365) - 1, 8); // EFU fixed rate
            $easypaisaRate = round($fundGrowthRate - $customerReturnRate - $efuLifeRate, 8);

            // Calculate profit components
            $cumulativeAmount = $saving->fund_growth_amount;
            $sumAssured = $cumulativeAmount * 1.25;

            $fundGrowthAmount = round($cumulativeAmount * $fundGrowthRate, 3);
            $efuLifeReturn = round($cumulativeAmount * $efuLifeRate, 3);
            $easypaisaReturn = round($cumulativeAmount * $easypaisaRate, 3);
            $customerReturnAmount = round($cumulativeAmount * $customerReturnRate, 3);

            // Calculate insurance components
            $sumAtRisk = max(0, $sumAssured - $cumulativeAmount);
            $mortalityCharge = round(($sumAtRisk * 0.8 / 1000) / 365, 3);
            $ptfShare = $mortalityCharge;
            $osfShare = max(0, $efuLifeReturn - $mortalityCharge);

            // Get last ledger entry for this saving
            $lastLedgerEntry = InvestmentLedgerSaving::where('saving_id', $saving->id)
                ->orderByDesc('date_time')
                ->first();

            $currentPrincipal = $lastLedgerEntry->principal_amount ?? $saving->initial_deposit;
            $currentProfit = $lastLedgerEntry->profit_amount ?? 0;
            $currentZakat = $lastLedgerEntry->zakat_amount ?? 0;
            $currentNetAmount = $lastLedgerEntry->net_amount ?? $saving->initial_deposit;
            
            
            $investment = $saving->fund_growth_amount ?? 0;
            $growthPercentage = (($currentBidPrice - $previousBidPrice) / $previousBidPrice) * 100;
            $profit_actual = round(($growthPercentage / 100) * $investment, 8);
             
             
            dd([
                'Current Bid Price' => $currentBidPrice,
                'Previous Bid Price' => $previousBidPrice,
                'Investment Amount' => $investment,
                'Growth Percentage' => round($growthPercentage, 3) . '%',
                'Profit (Actual)' => $profit_actual,
                'Calculation Breakdown' => "(({$currentBidPrice} - {$previousBidPrice}) / {$previousBidPrice}) * 100 = " . round($growthPercentage, 3) . "%",
                'Profit Formula' => "({$growthPercentage}% of {$investment}) = {$profit_actual}"
            ]);
            
            // return $profit_actual;

            // Create ledger entry
            $ledgerEntry = InvestmentLedgerSaving::create([
                'customer_id' => $saving->customer_id,
                'saving_id' => $saving->id,
                'customer_msisdn' => $saving->customer->user_msisdn ?? null,
                'transaction_id' => 'profit_'.uniqid(),
                'amount' => $customerReturnAmount,
                'principal_amount' => $currentPrincipal,
                'profit_amount' => $currentProfit + $customerReturnAmount,
                'zakat_amount' => $currentZakat,
                'transaction_type' => 'profit',
                'date_time' => now(),
                'net_amount' => $currentNetAmount + $customerReturnAmount,
                'gross_amount' => $customerReturnAmount,
                'breakdown' => [
                    'components' => [
                        'customer_share' => $customerReturnAmount,
                        'easypaisa_share' => $easypaisaReturn,
                        'efu_share' => $efuLifeReturn,
                        'mortality_charge' => $mortalityCharge
                    ],
                    'rates' => [
                        'fund_growth' => $fundGrowthRate,
                        'customer' => $customerReturnRate,
                        'easypaisa' => $easypaisaRate,
                        'efu_life' => $efuLifeRate
                    ],
                    'calculation_base' => [
                        'previous_principal' => $currentPrincipal,
                        'previous_profit' => $currentProfit,
                        'previous_zakat' => $currentZakat,
                        'previous_net' => $currentNetAmount
                    ]
                ]
            ]);

            // Create daily return record
            $newFundGrowthAmount = $cumulativeAmount + $customerReturnAmount;

            $dailyReturn = DailyReturn::create([
                'customer_id' => $saving->customer_id,
                'date' => now()->toDateString(),
                'saving_id' => $saving->id,
                'investment_ledger_saving_id' => $ledgerEntry->id,
                'customer_msisdn' => $saving->customer->user_msisdn ?? null,
                'customer_union_id' => $saving->customer_union_id,
                'initial_deposit' => $saving->initial_deposit,
                'fund_growth_amount' => $newFundGrowthAmount,
                'saving_status' => 'on-going',
                'saving_start_date' => $saving->saving_start_date,
                'saving_end_date' => $saving->saving_end_date,
                'amount_earned' => $customerReturnAmount,
                'commulative_amount' => $newFundGrowthAmount,
                'efu_share' => $efuLifeReturn,
                'easypaisa_share' => $easypaisaReturn,
                'customer_share' => $customerReturnAmount,
                'sum_assured' => $sumAssured,
                'sum_at_risk' => $sumAtRisk,
                'mortality_charges' => $mortalityCharge,
                'ptf_share' => $ptfShare,
                'osf_share' => $osfShare,
                'type' => 'profit',
                'todays_interest_rate' => $slabRate,
                'easypaisa_share_percentage' => $easypaisaRate,
                'efu_share_percentage' => $efuLifeRate,
                'customer_share_percentage' => $customerReturnRate,
                
            ]);

            // ✅ Now update the fund_growth_amount after ledger & return entry
            $saving->update(['fund_growth_amount' => $newFundGrowthAmount]);

            // Prepare API data
            $results[] = [
                'id' => $dailyReturn->id,
                'date' => $dailyReturn->date,
                'customer_id' => $saving->insurance->eful_policy_number ?? null,
                'saving_id' => $saving->id,
                'investment_ledger_saving_id' => $ledgerEntry->id,
                'amount_earned' => number_format($customerReturnAmount, 2, '.', ''),
                'commulative_amount' => number_format($newFundGrowthAmount - $saving->initial_deposit, 2, '.', ''),
                'fund_growth_amount' => number_format($newFundGrowthAmount, 2, '.', ''),
                'efu_share' => number_format($efuLifeReturn, 2, '.', ''),
                'easypaisa_share' => number_format($easypaisaReturn, 2, '.', ''),
                'customer_share' => number_format($customerReturnAmount, 2, '.', ''),
                'sum_assured' => number_format($sumAssured, 2, '.', ''),
                'sum_at_risk' => number_format($sumAtRisk, 2, '.', ''),
                'mortality_charges' => number_format($mortalityCharge, 2, '.', ''),
                'ptf_share' => number_format($ptfShare, 2, '.', ''),
                'osf_share' => number_format($osfShare, 2, '.', ''),
                'type' => 'profit',
                'todays_interest_rate' => $slabRate,
                'easypaisa_share_percentage' => number_format($easypaisaRate, 8, '.', ''),
                'efu_share_percentage' => number_format($efuLifeRate, 8, '.', ''),
                'customer_share_percentage' => number_format($customerReturnRate, 8, '.', ''),
                'hypo_rate' => $policyRate,
                'hypo_intrest' => number_format($fundGrowthAmount, 3, '.', ''),
                'actual_profit' => number_format($profit_actual, 5, '.', ''),
            ];
        }
        
        
       // dd($results);
        DB::commit();

        // External API call (consider dispatching this to a queue for performance)
        foreach ($results as $result) {
            $this->callExternalApi($result);
        }

        return response()->json([
            'status' => true,
            'message' => 'Daily profits calculated and distributed successfully',
            'data' => $results
        ]);

    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error('Daily profit calculation failed: '.$e->getMessage());

        return response()->json([
            'status' => false,
            'message' => 'Failed to calculate daily profits',
            'error' => $e->getMessage()
        ], 500);
    }
}

    

            protected function callExternalApi($data)
        {
            $url = 'https://api.efulife.com/epay/digi/tkf/sync/profit';
            $headers = [
                'Authorization: Bearer XXXXAAA123EPDIGITAKAFUL',
                'channelcode: EPDIGITAKAFUL',
                'Content-Type: application/json',
            ];

            // Prepare the request payload
            $payload = [
                'status' => 200,
                'message' => 'Daily returns retrieved successfully.',
                'data' => [$data] // Wrap the data in an array as per the example
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            
            if (curl_errno($ch)) {
                $error = curl_error($ch);
                curl_close($ch);
                throw new \Exception("cURL error: $error");
            }
            
            curl_close($ch);

            return [
                'http_code' => $httpCode,
                'response' => json_decode($response, true)
            ];
        }


    // Helper: AES Encryption
    private function aesEncrypt($plaintext)
    {
        $key = 'your-16-byte-aes-key'; // Replace with your AES key (must be 16/24/32 bytes)
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-128-cbc'));
        $ciphertext = openssl_encrypt($plaintext, 'aes-128-cbc', $key, OPENSSL_RAW_DATA, $iv);
        return base64_encode($iv . $ciphertext);
    }

    // Helper: Generate Encrypt Header
    private function generateEncryptHeader()
    {
        $symmetricKey = 'your-16-byte-aes-key'; // Same as AES key
        $publicKey = openssl_pkey_get_public($this->publicKey);

        if (!$publicKey) {
            Log::error("Invalid public key for encrypt header.");
            return '';
        }

        openssl_public_encrypt($symmetricKey, $encryptedSymmetricKey, $publicKey, OPENSSL_PKCS1_PADDING);
        openssl_free_key($publicKey);

        //return "jahangir";
        return "algorithm=RSA_AES,keyVersion=1,symmetricKey=" . urlencode(base64_encode($encryptedSymmetricKey));
    }

    // Helper: Signature Generation
    private function generateSignatureCashDeposit($data)
    {
        $privateKey = openssl_pkey_get_private($this->privateKey);

        if (!$privateKey) {
            Log::error("Error loading private key.");
            return '';
        }

        openssl_sign($data, $signature, $privateKey, OPENSSL_ALGO_SHA256);
        openssl_free_key($privateKey);

        return urlencode(base64_encode($signature));
    }



}