<?php $__env->startSection('title'); ?>
    <title>Users</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="ms-content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pl-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('superadmin.dashboard')); ?>"><i class="material-icons">home</i> Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('superadmin.index')); ?>">Users</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Update Users</li>
                </ol>
            </nav>
        </div>
        <div class="modal-body p-0 text-left">
            <div class="col-xl-12 col-md-12">
                <?php if(session('success')): ?>
                <div><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if($errors->any()): ?>
           <div class="alert alert-danger">
            <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
             </ul>
           </div>
          <?php endif; ?>
                <div class="ms-panel ms-panel-bshadow-none">
                    <div class="ms-panel-header">
                        <h6>User Information</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form action="<?php echo e(route('superadmin.users.update')); ?>" method="POST" class="needs-validation"  enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" id="id" class="form-control"
                            value="<?php echo e($user->id); ?>" required>

                            <div class="form-row">
                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom12">User Name </label>
                                    <div class="input-group">
                                        <input type="text" name="username" id="username" class="form-control"
                                        value="<?php echo e($user->username); ?>" required>

                                    </div>

                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom13">Update Password</label>
                                    <div class="input-group">
                                        <input type="password" name="password" id="password" class="form-control" placeholder="Enter Update Password" >
                                        <div class="input-group-append">
                                            <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                                <i class="fa fa-eye" id="eyeIcon"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom14">Employee Code </label>
                                    <div class="input-group">
                                        <input type="text" name="employee_code" id="employee_code" class="form-control"
                                            placeholder="Enter Employee Code " value="<?php echo e($user->employee_code); ?>" required>

                                    </div>
                                </div>
                            </div>



                            <div class="form-row">

                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom12">User Status </label>
                                    <div class="input-group">

                                        <select class="form-control" name="is_active" id="is_active" required>
                                            <option value="1" <?php echo e($user->is_active == 1 ? 'selected' : ''); ?>>User Active</option>
                                            <option value="0" <?php echo e($user->is_active == 0 ? 'selected' : ''); ?>>User In Active</option>
                                        </select>
                                    </div>

                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom15">Assign Role</label>
                                    <div class="input-group">
                                        <select class="form-control" name="role" id="role" required="">
                                            <option value="agent" <?php echo e($user->role == 'agent' ? 'selected' : ''); ?>>Agent</option>
                                            <option value="reporter" <?php echo e($user->role == 'reporter' ? 'selected' : ''); ?>>Reporter</option>

                                        </select>

                                    </div>
                                </div>

                            </div>

                            <button class="btn btn-danger mt-4 d-inline w-20" type="submit">Update</button>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>








<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Page Specific Scripts Finish -->
<script>
    document.getElementById('togglePassword').addEventListener('click', function (e) {
        // toggle the type attribute
        const passwordField = document.getElementById('password');
        const passwordFieldType = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', passwordFieldType);

        // toggle the eye icon
        const eyeIcon = document.getElementById('eyeIcon');
        if (passwordFieldType === 'password') {
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        } else {
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        }
    });
    </script>
<script src="<?php echo e(asset('admin/assets/js/calendar.js')); ?>"></script>
 <!-- Page Specific Scripts Start -->
 <script src="<?php echo e(asset('admin/assets/js/slick.min.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/moment.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/jquery.webticker.min.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/Chart.bundle.min.js')); ?>"> </script>
 <script src="<?php echo e(asset('admin/assets/js/index-chart.js')); ?>"> </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('superadmin..layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DELL 5591\Desktop\EFU Projects\Form\resources\views\admin\users\edit.blade.php ENDPATH**/ ?>