<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Plans;
use App\Models\Categories;
use App\Models\Products;

class Subscription extends Model
{
    use HasFactory;
    protected $table= 'subscriptions';
    public function plan()
    {
        return $this->belongsTo(Plans::class,'planid');
    }

    public function categories()
    {
        return $this->belongsTo(Categories::class ,'product_category_id');
    }

    public function products()
    {
        return $this->belongsTo(Products::class ,'product_id');
    }
}
