<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Plans;
use App\Models\Categories;

class Products extends Model
{
    use HasFactory;
    protected $table = 'jazz_products';
    protected $primaryKey = 'product_id';
    protected $fillable = ['planid','product_category_id','product_name','product_shortCode','product_description','price','duration','duration_days','pulse','cover_benefits'];



    public function plan()
    {
        return $this->belongsTo(Plans::class,'planid');
    }

    public function categories()
    {
        return $this->belongsTo(Categories::class ,'product_category_id');
    }


}
