<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCampaignSmsLogsTable extends Migration
{
    public function up()
    {
        Schema::create('campaign_sms_logs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('campaign_id', 50)->index();
            $table->string('msisdn', 20)->index();
            $table->integer('call_duration')->default(0);
            $table->string('message_template_id', 50)->nullable();
            $table->string('message_id', 50)->nullable()->index();
            $table->string('status', 20)->default('pending')->index();
            $table->timestamp('api_timestamp')->nullable();
            $table->timestamps();

            // Optional composite index for performance
            $table->index(['campaign_id', 'msisdn']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('campaign_sms_logs');
    }
}
