<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\CampaignSmsLog;

class SmsApiController extends Controller
{
    public function send(Request $request)
    {
        $data = $request->validate([
            'msisdn'              => 'required|string|max:20',
            'campaign_id'         => 'required|string|max:50',
            'call_duration'       => 'required|integer|min:12',
            'message_template_id' => 'required|string|max:50',
            'timestamp'           => 'required|date',
        ]);

        // 1️⃣ If call duration < 12 seconds, ignore
        if ($data['call_duration'] < 12) {
            return response()->json([
                'status' => 'ignored',
                'message' => 'Call duration below 12 seconds'
            ], 200);
        }

        // 2️⃣ Prepare message content (you can extend this by template)
        $message = "Shukriya! apka IVR campaign subscription successful hai. Campaign: {$data['campaign_id']}";

        // 3️⃣ Prepare payload for JazzCash Gateway
        $payload = [
            'msisdn'      => $data['msisdn'],
            'content'     => $message,
            'referenceId' => uniqid(),
        ];

        // 4️⃣ Encrypt the payload using your existing encryption scheme
          $key = 'mYjC!nc3dibleY3k';         // 16 characters
        $iv = 'Myin!tv3ctorjCM@'; 
        $cipher = 'AES-128-CBC';

        $key = 'mYjC!nc3dibleY3k';         // 16 characters
        $iv = 'Myin!tv3ctorjCM@'; 

        $jsonData        = json_encode($payload);
        $encryptedBinary = openssl_encrypt($jsonData, $cipher, $key, OPENSSL_RAW_DATA, $iv);
        $encryptedHex    = bin2hex($encryptedBinary);

        $body = json_encode(['data' => $encryptedHex]);

        // 5️⃣ Send request to JazzCash SMS Delivery API
        $curl = curl_init('https://gateway-sandbox.jazzcash.com.pk/jazzcash/third-party-integration/rest/api/wso2/v1/insurance/notification');
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => $body,
            CURLOPT_HTTPHEADER     => [
                'Content-Type: application/json',
                'X-CLIENT-ID: 946658113e89d870aad2e47f715c2b72',
                'X-CLIENT-SECRET: e5a0279efbd7bd797e472d0ce9eebb69',
                'X-PARTNER-ID: 946658113e89d870aad2e47f715c2b72',
            ],
        ]);

        $response = curl_exec($curl);
        $error    = curl_error($curl);
        curl_close($curl);

        // 6️⃣ Log data in DB
        $log = CampaignSmsLog::create([
            'campaign_id'         => $data['campaign_id'],
            'msisdn'              => $data['msisdn'],
            'call_duration'       => $data['call_duration'],
            'message_template_id' => $data['message_template_id'],
            'message_id'          => $payload['referenceId'],
            'status'              => $error ? 'failed' : 'success',
            'api_timestamp'       => now(),
        ]);

        // 7️⃣ Write system log for debugging
        Log::channel('message_api')->info('IVR → Jazz SMS Gateway', [
            'msisdn'    => $data['msisdn'],
            'campaign'  => $data['campaign_id'],
            'payload'   => $payload,
            'response'  => $response,
            'error'     => $error,
        ]);

        // 8️⃣ Return standard EFU Gateway API response
        if ($error) {
            return response()->json([
                'status'     => 'failed',
                'message_id' => $payload['referenceId'],
                'error'      => $error,
                'timestamp'  => now(),
            ], 500);
        }

        return response()->json([
            'status'     => 'success',
            'message_id' => $payload['referenceId'],
            'timestamp'  => now(),
        ], 200);
    }
}
